/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.SignatureCreationDateComparator;
import org.pgpainless.signature.SignatureValidator;
import org.pgpainless.signature.SignatureValidityComparator;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

public class SignatureChainValidator {
    private static final Logger LOGGER = Logger.getLogger(SignatureChainValidator.class.getName());

    public static boolean validateSigningKey(PGPSignature signature, PGPPublicKeyRing signingKeyRing, Policy policy) throws SignatureValidationException {
        PGPSignature userIdSig;
        ConcurrentHashMap<PGPSignature, Exception> rejections = new ConcurrentHashMap<PGPSignature, Exception>();
        PGPPublicKey signingSubkey = signingKeyRing.getPublicKey(signature.getKeyID());
        if (signingSubkey == null) {
            throw new SignatureValidationException("Provided key ring does not contain a subkey with id " + Long.toHexString(signature.getKeyID()));
        }
        PGPPublicKey primaryKey = signingKeyRing.getPublicKey();
        ArrayList<PGPSignature> directKeySignatures = new ArrayList<PGPSignature>();
        Iterator primaryKeyRevocationIterator = primaryKey.getSignaturesOfType(SignatureType.KEY_REVOCATION.getCode());
        while (primaryKeyRevocationIterator.hasNext()) {
            PGPSignature revocation = (PGPSignature)primaryKeyRevocationIterator.next();
            try {
                if (!SignatureValidator.verifyKeyRevocationSignature(revocation, primaryKey, policy, signature.getCreationTime())) continue;
                directKeySignatures.add(revocation);
            }
            catch (SignatureValidationException e) {
                rejections.put(revocation, e);
                LOGGER.log(Level.FINE, "Rejecting key revocation signature.", e);
            }
        }
        Iterator keySignatures = primaryKey.getSignaturesOfType(SignatureType.DIRECT_KEY.getCode());
        while (keySignatures.hasNext()) {
            PGPSignature keySignature = (PGPSignature)keySignatures.next();
            try {
                if (!SignatureValidator.verifyDirectKeySignature(keySignature, primaryKey, policy, signature.getCreationTime())) continue;
                directKeySignatures.add(keySignature);
            }
            catch (SignatureValidationException e) {
                rejections.put(keySignature, e);
                LOGGER.log(Level.FINE, "Rejecting key signature.", e);
            }
        }
        Collections.sort(directKeySignatures, new SignatureValidityComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
        if (!directKeySignatures.isEmpty() && ((PGPSignature)directKeySignatures.get(0)).getSignatureType() == SignatureType.KEY_REVOCATION.getCode()) {
            throw new SignatureValidationException("Primary key has been revoked.");
        }
        Iterator<String> userIds = primaryKey.getUserIDs();
        ConcurrentHashMap userIdSignatures = new ConcurrentHashMap();
        while (userIds.hasNext()) {
            ArrayList<PGPSignature> signaturesOnUserId = new ArrayList<PGPSignature>();
            String userId = userIds.next();
            Iterator<PGPSignature> userIdSigs = primaryKey.getSignaturesForID(userId);
            while (userIdSigs.hasNext()) {
                PGPSignature userIdSig2 = userIdSigs.next();
                try {
                    if (!SignatureValidator.verifySignatureOverUserId(userId, userIdSig2, primaryKey, policy, signature.getCreationTime())) continue;
                    signaturesOnUserId.add(userIdSig2);
                }
                catch (SignatureValidationException e) {
                    rejections.put(userIdSig2, e);
                    LOGGER.log(Level.INFO, "Rejecting user-id signature.", e);
                }
            }
            Collections.sort(signaturesOnUserId, new SignatureValidityComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
            userIdSignatures.put(userId, signaturesOnUserId);
        }
        boolean anyUserIdValid = false;
        for (String userId : userIdSignatures.keySet()) {
            if (((List)userIdSignatures.get(userId)).isEmpty()) continue;
            PGPSignature current = (PGPSignature)((List)userIdSignatures.get(userId)).get(0);
            if (current.getSignatureType() == SignatureType.CERTIFICATION_REVOCATION.getCode()) {
                LOGGER.log(Level.FINE, "User-ID '" + userId + "' is revoked.");
                continue;
            }
            anyUserIdValid = true;
        }
        if (!anyUserIdValid) {
            throw new SignatureValidationException("No valid user-id found.", rejections);
        }
        SignerUserID signerUserID = SignatureSubpacketsUtil.getSignerUserID(signature);
        if (signerUserID != null && (userIdSig = (PGPSignature)((List)userIdSignatures.get(signerUserID.getID())).get(0)).getSignatureType() == SignatureType.CERTIFICATION_REVOCATION.getCode()) {
            throw new SignatureValidationException("Signature was made with user-id '" + signerUserID.getID() + "' which is revoked.");
        }
        if (signingSubkey == primaryKey) {
            if (!directKeySignatures.isEmpty() && KeyFlag.hasKeyFlag(SignatureSubpacketsUtil.getKeyFlags((PGPSignature)directKeySignatures.get(0)).getFlags(), KeyFlag.SIGN_DATA)) {
                return true;
            }
        } else {
            ArrayList<PGPSignature> subkeySigs = new ArrayList<PGPSignature>();
            Iterator bindingRevocations = signingSubkey.getSignaturesOfType(SignatureType.SUBKEY_REVOCATION.getCode());
            while (bindingRevocations.hasNext()) {
                PGPSignature revocation = (PGPSignature)bindingRevocations.next();
                try {
                    if (!SignatureValidator.verifySubkeyBindingRevocation(revocation, primaryKey, signingSubkey, policy, signature.getCreationTime())) continue;
                    subkeySigs.add(revocation);
                }
                catch (SignatureValidationException e) {
                    rejections.put(revocation, e);
                    LOGGER.log(Level.FINE, "Rejecting subkey revocation signature.", e);
                }
            }
            Iterator bindingSigs = signingSubkey.getSignaturesOfType(SignatureType.SUBKEY_BINDING.getCode());
            while (bindingSigs.hasNext()) {
                PGPSignature bindingSig = (PGPSignature)bindingSigs.next();
                try {
                    if (!SignatureValidator.verifySubkeyBindingSignature(bindingSig, primaryKey, signingSubkey, policy, signature.getCreationTime())) continue;
                    subkeySigs.add(bindingSig);
                }
                catch (SignatureValidationException e) {
                    rejections.put(bindingSig, e);
                    LOGGER.log(Level.FINE, "Rejecting subkey binding signature.", e);
                }
            }
            Collections.sort(subkeySigs, new SignatureValidityComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
            if (subkeySigs.isEmpty()) {
                throw new SignatureValidationException("Subkey is not bound.", rejections);
            }
            PGPSignature currentSig = (PGPSignature)subkeySigs.get(0);
            if (currentSig.getSignatureType() == SignatureType.SUBKEY_REVOCATION.getCode()) {
                throw new SignatureValidationException("Subkey is revoked.");
            }
            if (!KeyFlag.hasKeyFlag(SignatureSubpacketsUtil.getKeyFlags(currentSig).getFlags(), KeyFlag.SIGN_DATA)) {
                throw new SignatureValidationException("Signature was made by key which is not capable of signing.");
            }
        }
        return true;
    }

    public static boolean validateSignatureChain(PGPSignature signature, InputStream signedData, PGPPublicKeyRing signingKeyRing, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureChainValidator.validateSigningKey(signature, signingKeyRing, policy);
        return SignatureValidator.verifyUninitializedSignature(signature, signedData, signingKeyRing.getPublicKey(signature.getKeyID()), policy, validationDate);
    }

    public static boolean validateSignature(PGPSignature signature, PGPPublicKeyRing verificationKeys, Policy policy) throws SignatureValidationException {
        SignatureChainValidator.validateSigningKey(signature, verificationKeys, policy);
        PGPPublicKey signingKey = verificationKeys.getPublicKey(signature.getKeyID());
        SignatureValidator.verifyInitializedSignature(signature, signingKey, policy, signature.getCreationTime());
        return true;
    }
}

