/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.signature.SelectSignatureFromKey;
import org.pgpainless.signature.SignatureCreationDateComparator;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.CollectionUtils;

public class SignaturePicker {
    public static PGPSignature pickCurrentRevocationSelfSignature(PGPKeyRing keyRing, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        List<PGPSignature> signatures = SignaturePicker.getSortedSignaturesOfType(primaryKey, SignatureType.KEY_REVOCATION);
        PGPSignature mostCurrentValidSig = null;
        for (PGPSignature signature : signatures) {
            RevocationReason reason;
            if (!SelectSignatureFromKey.isWellFormed().accept(signature, primaryKey, keyRing) || !SelectSignatureFromKey.isCreatedBy(keyRing.getPublicKey()).accept(signature, primaryKey, keyRing) || (reason = SignatureSubpacketsUtil.getRevocationReason(signature)) != null && !RevocationAttributes.Reason.isHardRevocation(reason.getRevocationReason()) && !SelectSignatureFromKey.isValidAt(validationDate).accept(signature, primaryKey, keyRing) || !SelectSignatureFromKey.isValidKeyRevocationSignature(primaryKey).accept(signature, primaryKey, keyRing)) continue;
            mostCurrentValidSig = signature;
        }
        return mostCurrentValidSig;
    }

    public static PGPSignature pickCurrentDirectKeySelfSignature(PGPKeyRing keyRing, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        return SignaturePicker.pickCurrentDirectKeySignature(primaryKey, primaryKey, keyRing, validationDate);
    }

    public static PGPSignature pickCurrentDirectKeySignature(PGPPublicKey signingKey, PGPPublicKey signedKey, PGPKeyRing keyRing, Date validationDate) {
        List<PGPSignature> directKeySignatures = SignaturePicker.getSortedSignaturesOfType(signedKey, SignatureType.DIRECT_KEY);
        PGPSignature mostRecentDirectKeySigBySigningKey = null;
        for (PGPSignature signature : directKeySignatures) {
            if (!SelectSignatureFromKey.isWellFormed().accept(signature, signingKey, keyRing) || !SelectSignatureFromKey.isValidAt(validationDate).accept(signature, signedKey, keyRing) || !SelectSignatureFromKey.isValidDirectKeySignature(signingKey, signedKey).accept(signature, signedKey, keyRing)) continue;
            mostRecentDirectKeySigBySigningKey = signature;
        }
        return mostRecentDirectKeySigBySigningKey;
    }

    public static PGPSignature pickCurrentUserIdRevocationSignature(PGPKeyRing keyRing, String userId, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        Iterator certificationRevocations = primaryKey.getSignaturesOfType(SignatureType.CERTIFICATION_REVOCATION.getCode());
        List<PGPSignature> signatures = CollectionUtils.iteratorToList(certificationRevocations);
        Collections.sort(signatures, new SignatureCreationDateComparator());
        PGPSignature mostRecentUserIdRevocation = null;
        for (PGPSignature signature : signatures) {
            RevocationReason reason;
            if (!SelectSignatureFromKey.isWellFormed().accept(signature, primaryKey, keyRing) || (reason = SignatureSubpacketsUtil.getRevocationReason(signature)) != null && !RevocationAttributes.Reason.isHardRevocation(reason.getRevocationReason()) && !SelectSignatureFromKey.isValidAt(validationDate).accept(signature, primaryKey, keyRing) || !SelectSignatureFromKey.isValidCertificationRevocationSignature(primaryKey, userId).accept(signature, primaryKey, keyRing)) continue;
            mostRecentUserIdRevocation = signature;
        }
        return mostRecentUserIdRevocation;
    }

    public static PGPSignature pickCurrentUserIdCertificationSignature(PGPKeyRing keyRing, String userId, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        Iterator<PGPSignature> userIdSigIterator = primaryKey.getSignaturesForID(userId);
        List<PGPSignature> signatures = CollectionUtils.iteratorToList(userIdSigIterator);
        Collections.sort(signatures, new SignatureCreationDateComparator());
        PGPSignature mostRecentUserIdCertification = null;
        for (PGPSignature signature : signatures) {
            if (!SelectSignatureFromKey.isWellFormed().accept(signature, primaryKey, keyRing) || !SelectSignatureFromKey.isValidAt(validationDate).accept(signature, primaryKey, keyRing) || !SelectSignatureFromKey.isValidSignatureOnUserId(userId, primaryKey).accept(signature, primaryKey, keyRing)) continue;
            mostRecentUserIdCertification = signature;
        }
        return mostRecentUserIdCertification;
    }

    public static PGPSignature pickCurrentSubkeyBindingRevocationSignature(PGPKeyRing keyRing, PGPPublicKey subkey, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        if (primaryKey.getKeyID() == subkey.getKeyID()) {
            throw new IllegalArgumentException("Primary key cannot have subkey binding revocations.");
        }
        List<PGPSignature> subkeyRevocationSigs = SignaturePicker.getSortedSignaturesOfType(subkey, SignatureType.SUBKEY_BINDING);
        PGPSignature mostRecentSubkeyRevocation = null;
        for (PGPSignature signature : subkeyRevocationSigs) {
            RevocationReason reason;
            if (!SelectSignatureFromKey.isWellFormed().accept(signature, primaryKey, keyRing) || (reason = SignatureSubpacketsUtil.getRevocationReason(signature)) != null && !RevocationAttributes.Reason.isHardRevocation(reason.getRevocationReason()) && !SelectSignatureFromKey.isValidAt(validationDate).accept(signature, primaryKey, keyRing) || !SelectSignatureFromKey.isValidSubkeyRevocationSignature().accept(signature, subkey, keyRing)) continue;
            mostRecentSubkeyRevocation = signature;
        }
        return mostRecentSubkeyRevocation;
    }

    public static PGPSignature pickCurrentSubkeyBindingSignature(PGPKeyRing keyRing, PGPPublicKey subkey, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        if (primaryKey.getKeyID() == subkey.getKeyID()) {
            throw new IllegalArgumentException("Primary key cannot have subkey binding signature.");
        }
        List<PGPSignature> subkeyBindingSigs = SignaturePicker.getSortedSignaturesOfType(subkey, SignatureType.SUBKEY_BINDING);
        PGPSignature mostCurrentValidSig = null;
        for (PGPSignature signature : subkeyBindingSigs) {
            SignatureCreationTime creationTime;
            if (!SelectSignatureFromKey.isWellFormed().accept(signature, primaryKey, keyRing) || (creationTime = SignatureSubpacketsUtil.getSignatureCreationTime(signature)).getTime().after(validationDate) || SignatureUtils.isSignatureExpired(signature, validationDate) || !SelectSignatureFromKey.isValidSubkeyBindingSignature(primaryKey, subkey).accept(signature, subkey, keyRing)) continue;
            mostCurrentValidSig = signature;
        }
        return mostCurrentValidSig;
    }

    private static List<PGPSignature> getSortedSignaturesOfType(PGPPublicKey key, SignatureType type) {
        Iterator signaturesOfType = key.getSignaturesOfType(type.getCode());
        List<PGPSignature> signatureList = CollectionUtils.iteratorToList(signaturesOfType);
        Collections.sort(signatureList, new SignatureCreationDateComparator());
        return signatureList;
    }
}

