/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.OpenPgpKeyAttributeUtil;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

public class SignatureUtils {
    public static PGPSignatureGenerator getSignatureGeneratorFor(PGPSecretKey singingKey) {
        return SignatureUtils.getSignatureGeneratorFor(singingKey.getPublicKey());
    }

    public static PGPSignatureGenerator getSignatureGeneratorFor(PGPPublicKey signingPubKey) {
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(SignatureUtils.getPgpContentSignerBuilderForKey(signingPubKey));
        return signatureGenerator;
    }

    private static PGPContentSignerBuilder getPgpContentSignerBuilderForKey(PGPPublicKey publicKey) {
        List<HashAlgorithm> preferredHashAlgorithms = OpenPgpKeyAttributeUtil.getPreferredHashAlgorithms(publicKey);
        if (preferredHashAlgorithms.isEmpty()) {
            preferredHashAlgorithms = OpenPgpKeyAttributeUtil.guessPreferredHashAlgorithms(publicKey);
        }
        HashAlgorithm hashAlgorithm = SignatureUtils.negotiateHashAlgorithm(preferredHashAlgorithms);
        return ImplementationFactory.getInstance().getPGPContentSignerBuilder(publicKey.getAlgorithm(), hashAlgorithm.getAlgorithmId());
    }

    private static HashAlgorithm negotiateHashAlgorithm(List<HashAlgorithm> preferredHashAlgorithms) {
        Policy policy = PGPainless.getPolicy();
        for (HashAlgorithm option : preferredHashAlgorithms) {
            if (!policy.getSignatureHashAlgorithmPolicy().isAcceptable(option)) continue;
            return option;
        }
        return PGPainless.getPolicy().getSignatureHashAlgorithmPolicy().defaultHashAlgorithm();
    }

    public static PGPSignature getLatestValidSignature(PGPPublicKey publicKey, List<PGPSignature> signatures, PGPKeyRing keyRing) throws PGPException {
        ArrayList<PGPSignature> valid = new ArrayList<PGPSignature>();
        for (PGPSignature signature : signatures) {
            long issuerID = signature.getKeyID();
            PGPPublicKey issuer = KeyRingUtils.getPublicKeyFrom(keyRing, issuerID);
            if (issuer == null || !SignatureUtils.isSignatureValid(signature, issuer, publicKey) || SignatureUtils.isSignatureExpired(signature)) continue;
            valid.add(signature);
        }
        SignatureUtils.sortByCreationTimeAscending(valid);
        return valid.isEmpty() ? null : (PGPSignature)valid.get(valid.size() - 1);
    }

    public static boolean isSignatureValid(PGPSignature signature, PGPPublicKey issuer, PGPPublicKey target) throws PGPException {
        SignatureType signatureType = SignatureType.valueOf(signature.getSignatureType());
        switch (signatureType) {
            case BINARY_DOCUMENT: 
            case CANONICAL_TEXT_DOCUMENT: 
            case STANDALONE: 
            case TIMESTAMP: 
            case THIRD_PARTY_CONFIRMATION: {
                throw new IllegalArgumentException("Signature is not a key signature.");
            }
            case GENERIC_CERTIFICATION: 
            case NO_CERTIFICATION: 
            case CASUAL_CERTIFICATION: 
            case POSITIVE_CERTIFICATION: 
            case DIRECT_KEY: {
                return SignatureUtils.isSelfSignatureValid(signature, issuer);
            }
            case KEY_REVOCATION: 
            case CERTIFICATION_REVOCATION: {
                return SignatureUtils.isRevocationSignatureValid(signature, issuer);
            }
            case SUBKEY_BINDING: 
            case PRIMARYKEY_BINDING: 
            case SUBKEY_REVOCATION: {
                return SignatureUtils.isKeyOnKeySignatureValid(signature, issuer, target);
            }
        }
        return false;
    }

    public static boolean isKeyOnKeySignatureValid(PGPSignature signature, PGPPublicKey issuer, PGPPublicKey target) throws PGPException {
        signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), issuer);
        return signature.verifyCertification(issuer, target);
    }

    public static boolean isSelfSignatureValid(PGPSignature signature, PGPPublicKey publicKey) throws PGPException {
        if (!PGPainless.getPolicy().getSignatureHashAlgorithmPolicy().isAcceptable(signature.getHashAlgorithm())) {
            return false;
        }
        Iterator<String> it = publicKey.getUserIDs();
        while (it.hasNext()) {
            String userId = it.next();
            boolean valid = SignatureUtils.isSelfSignatureOnUserIdValid(signature, userId, publicKey);
            if (!valid) continue;
            return true;
        }
        return false;
    }

    public static boolean isRevocationSignatureValid(PGPSignature signature, PGPPublicKey publicKey) throws PGPException {
        if (!PGPainless.getPolicy().getRevocationSignatureHashAlgorithmPolicy().isAcceptable(signature.getHashAlgorithm())) {
            return false;
        }
        Iterator<String> it = publicKey.getUserIDs();
        while (it.hasNext()) {
            String userId = it.next();
            boolean valid = SignatureUtils.isSelfSignatureOnUserIdValid(signature, userId, publicKey);
            if (!valid) continue;
            return true;
        }
        return false;
    }

    public static boolean isSelfSignatureOnUserIdValid(PGPSignature signature, String userId, PGPPublicKey publicKey) throws PGPException {
        signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), publicKey);
        return signature.verifyCertification(userId, publicKey);
    }

    public static Date getKeyExpirationDate(Date keyCreationDate, PGPSignature signature) {
        KeyExpirationTime keyExpirationTime = SignatureSubpacketsUtil.getKeyExpirationTime(signature);
        long expiresInSecs = keyExpirationTime == null ? 0L : keyExpirationTime.getTime();
        return SignatureUtils.datePlusSeconds(keyCreationDate, expiresInSecs);
    }

    public static Date getSignatureExpirationDate(PGPSignature signature) {
        Date creationDate = signature.getCreationTime();
        SignatureExpirationTime signatureExpirationTime = SignatureSubpacketsUtil.getSignatureExpirationTime(signature);
        long expiresInSecs = signatureExpirationTime == null ? 0L : signatureExpirationTime.getTime();
        return SignatureUtils.datePlusSeconds(creationDate, expiresInSecs);
    }

    public static Date datePlusSeconds(Date date, long seconds) {
        if (seconds == 0L) {
            return null;
        }
        return new Date(date.getTime() + 1000L * seconds);
    }

    public static boolean isSignatureExpired(PGPSignature signature) {
        return SignatureUtils.isSignatureExpired(signature, new Date());
    }

    public static boolean isSignatureExpired(PGPSignature signature, Date comparisonDate) {
        Date expirationDate = SignatureUtils.getSignatureExpirationDate(signature);
        return expirationDate != null && comparisonDate.after(expirationDate);
    }

    public static void sortByCreationTimeAscending(List<PGPSignature> signatures) {
        Collections.sort(signatures, new Comparator<PGPSignature>(){

            @Override
            public int compare(PGPSignature s1, PGPSignature s2) {
                return s1.getCreationTime().compareTo(s2.getCreationTime());
            }
        });
    }

    public static List<PGPSignature> getBindingSignatures(PGPPublicKey subKey, long primaryKeyId) {
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        List<PGPSignature> bindingSigs = SignatureUtils.getSignaturesOfTypes(subKey, SignatureType.SUBKEY_BINDING);
        for (PGPSignature signature : bindingSigs) {
            if (signature.getKeyID() != primaryKeyId) continue;
            signatures.add(signature);
        }
        return signatures;
    }

    public static List<PGPSignature> getSignaturesOfTypes(PGPPublicKey publicKey, SignatureType ... types) {
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        for (SignatureType type : types) {
            Iterator it = publicKey.getSignaturesOfType(type.getCode());
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof PGPSignature)) continue;
                signatures.add((PGPSignature)o);
            }
        }
        SignatureUtils.sortByCreationTimeAscending(signatures);
        return signatures;
    }

    public static List<PGPSignature> getSignaturesForUserId(PGPPublicKey publicKey, String userId) {
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        Iterator<PGPSignature> it = publicKey.getSignaturesForID(userId);
        while (it != null && it.hasNext()) {
            PGPSignature o = it.next();
            if (!(o instanceof PGPSignature)) continue;
            signatures.add(o);
        }
        SignatureUtils.sortByCreationTimeAscending(signatures);
        return signatures;
    }

    public static PGPSignature getLatestSelfSignatureForUserId(PGPPublicKey publicKey, String userId) throws PGPException {
        ArrayList<PGPSignature> valid = new ArrayList<PGPSignature>();
        List<PGPSignature> signatures = SignatureUtils.getSignaturesForUserId(publicKey, userId);
        for (PGPSignature signature : signatures) {
            if (!SignatureUtils.isSelfSignatureOnUserIdValid(signature, userId, publicKey)) continue;
            valid.add(signature);
        }
        return valid.isEmpty() ? null : (PGPSignature)valid.get(valid.size() - 1);
    }

    public static boolean isUserIdValid(PGPPublicKey publicKey, String userId) throws PGPException {
        return SignatureUtils.isUserIdValid(publicKey, userId, new Date());
    }

    public static boolean isUserIdValid(PGPPublicKey publicKey, String userId, Date validationDate) throws PGPException {
        PGPSignature latestSelfSig = SignatureUtils.getLatestSelfSignatureForUserId(publicKey, userId);
        if (latestSelfSig == null) {
            return false;
        }
        if (latestSelfSig.getCreationTime().after(validationDate)) {
            return false;
        }
        if (SignatureUtils.isSignatureExpired(latestSelfSig, validationDate)) {
            return false;
        }
        return latestSelfSig.getSignatureType() != SignatureType.CERTIFICATION_REVOCATION.getCode();
    }

    public static boolean isHardRevocation(PGPSignature signature) {
        SignatureType type = SignatureType.valueOf(signature.getSignatureType());
        if (type != SignatureType.KEY_REVOCATION && type != SignatureType.SUBKEY_REVOCATION && type != SignatureType.CERTIFICATION_REVOCATION) {
            return false;
        }
        RevocationReason reasonSubpacket = SignatureSubpacketsUtil.getRevocationReason(signature);
        if (reasonSubpacket == null) {
            return true;
        }
        return RevocationAttributes.Reason.isHardRevocation(reasonSubpacket.getRevocationReason());
    }
}

