/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;

public interface EncryptionBuilderInterface {
    default public ToRecipients onOutputStream(@Nonnull OutputStream outputStream) {
        return this.onOutputStream(outputStream, OpenPgpMetadata.FileInfo.binaryStream());
    }

    default public ToRecipients onOutputStream(@Nonnull OutputStream outputStream, boolean forYourEyesOnly) {
        return this.onOutputStream(outputStream, forYourEyesOnly ? OpenPgpMetadata.FileInfo.forYourEyesOnly() : OpenPgpMetadata.FileInfo.binaryStream());
    }

    default public ToRecipients onOutputStream(@Nonnull OutputStream outputStream, String fileName, boolean forYourEyesOnly) {
        return this.onOutputStream(outputStream, new OpenPgpMetadata.FileInfo(forYourEyesOnly ? "_CONSOLE" : fileName, new Date(), StreamEncoding.BINARY));
    }

    public ToRecipients onOutputStream(@Nonnull OutputStream var1, OpenPgpMetadata.FileInfo var2);

    public static interface Armor {
        public EncryptionStream asciiArmor() throws IOException, PGPException;

        public EncryptionStream noArmor() throws IOException, PGPException;
    }

    public static interface DocumentType {
        public Armor signBinaryDocument();

        public Armor signCanonicalText();
    }

    public static interface SignWith {
        public DocumentType signWith(@Nonnull SecretKeyRingProtector var1, PGPSecretKeyRing ... var2);

        public DocumentType signWith(@Nonnull SecretKeyRingProtector var1, @Nonnull PGPSecretKeyRingCollection var2);
    }

    public static interface DetachedSign
    extends SignWith {
        public SignWith createDetachedSignature();

        public Armor doNotSign();
    }

    public static interface WithAlgorithms {
        public WithAlgorithms andToSelf(PGPPublicKeyRing ... var1);

        public WithAlgorithms andToSelf(@Nonnull PGPPublicKeyRingCollection var1);

        public DetachedSign usingAlgorithms(@Nonnull SymmetricKeyAlgorithm var1, @Nonnull HashAlgorithm var2, @Nonnull CompressionAlgorithm var3);

        public DetachedSign usingSecureAlgorithms();

        public ToRecipients and();
    }

    public static interface ToRecipients {
        public WithAlgorithms toRecipients(PGPPublicKeyRing ... var1);

        public WithAlgorithms toRecipients(PGPPublicKeyRingCollection ... var1);

        public WithAlgorithms forPassphrases(Passphrase ... var1);

        public DetachedSign doNotEncrypt();
    }
}

