/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.pgpainless.algorithm.PublicKeyAlgorithm;

public class KeyInfo {
    private final PGPSecretKey secretKey;
    private final PGPPublicKey publicKey;

    public KeyInfo(PGPSecretKey secretKey) {
        this.secretKey = secretKey;
        this.publicKey = secretKey.getPublicKey();
    }

    public KeyInfo(PGPPublicKey publicKey) {
        this.publicKey = publicKey;
        this.secretKey = null;
    }

    public String getCurveName() {
        return KeyInfo.getCurveName(this.publicKey);
    }

    public boolean isEncrypted() {
        return this.secretKey != null && KeyInfo.isEncrypted(this.secretKey);
    }

    public boolean isDecrypted() {
        return this.secretKey == null || KeyInfo.isDecrypted(this.secretKey);
    }

    public boolean hasDummyS2K() {
        return this.secretKey != null && KeyInfo.hasDummyS2K(this.secretKey);
    }

    public static String getCurveName(PGPPublicKey publicKey) {
        ECPublicBCPGKey key;
        PublicKeyAlgorithm algorithm = PublicKeyAlgorithm.fromId(publicKey.getAlgorithm());
        switch (algorithm) {
            case ECDSA: {
                key = (ECDSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                break;
            }
            case ECDH: {
                key = (ECDHPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                break;
            }
            case EDDSA: {
                key = (EdDSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a EC public key (" + (Object)((Object)algorithm) + ")");
            }
        }
        return KeyInfo.getCurveName(key);
    }

    public static String getCurveName(ECPublicBCPGKey key) {
        return ECUtil.getCurveName(key.getCurveOID());
    }

    public static boolean isEncrypted(PGPSecretKey secretKey) {
        return secretKey.getS2KUsage() != 0;
    }

    public static boolean isDecrypted(PGPSecretKey secretKey) {
        return secretKey.getS2KUsage() == 0;
    }

    public static boolean hasDummyS2K(PGPSecretKey secretKey) {
        S2K s2k = secretKey.getS2K();
        return s2k != null && s2k.getType() == 101;
    }
}

