/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.info.KeyInfo;
import org.pgpainless.signature.SignaturePicker;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.CollectionUtils;

public class KeyRingInfo {
    private static final Pattern PATTERN_EMAIL = Pattern.compile("[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,6}");
    private final PGPKeyRing keys;
    private final PGPSignature revocationSelfSignature;
    private final PGPSignature mostRecentSelfSignature;
    private final Map<String, PGPSignature> mostRecentUserIdSignatures = new ConcurrentHashMap<String, PGPSignature>();
    private final Map<String, PGPSignature> mostRecentUserIdRevocations = new ConcurrentHashMap<String, PGPSignature>();
    private final Map<Long, PGPSignature> mostRecentSubkeyBindings = new ConcurrentHashMap<Long, PGPSignature>();
    private final Map<Long, PGPSignature> mostRecentSubkeyRevocations = new ConcurrentHashMap<Long, PGPSignature>();

    public static KeyRingInfo evaluateForSignature(PGPKeyRing keyRing, PGPSignature signature) {
        return new KeyRingInfo(keyRing, signature.getCreationTime());
    }

    public KeyRingInfo(PGPKeyRing keys) {
        this(keys, new Date());
    }

    public KeyRingInfo(PGPKeyRing keys, Date validationDate) {
        this.keys = keys;
        this.revocationSelfSignature = SignaturePicker.pickCurrentRevocationSelfSignature(keys, validationDate);
        this.mostRecentSelfSignature = SignaturePicker.pickCurrentDirectKeySelfSignature(keys, validationDate);
        Iterator<String> it = keys.getPublicKey().getUserIDs();
        while (it.hasNext()) {
            PGPSignature revocation;
            String userId = it.next();
            PGPSignature certification = SignaturePicker.pickCurrentUserIdCertificationSignature(keys, userId, validationDate);
            if (certification != null) {
                this.mostRecentUserIdSignatures.put(userId, certification);
            }
            if ((revocation = SignaturePicker.pickCurrentUserIdRevocationSignature(keys, userId, validationDate)) == null) continue;
            this.mostRecentUserIdRevocations.put(userId, revocation);
        }
        Iterator<PGPPublicKey> publicKeys = keys.getPublicKeys();
        publicKeys.next();
        while (publicKeys.hasNext()) {
            PGPSignature bindingRevocation;
            PGPPublicKey subkey = publicKeys.next();
            PGPSignature bindingSig = SignaturePicker.pickCurrentSubkeyBindingSignature(keys, subkey, validationDate);
            if (bindingSig != null) {
                this.mostRecentSubkeyBindings.put(subkey.getKeyID(), bindingSig);
            }
            if ((bindingRevocation = SignaturePicker.pickCurrentSubkeyBindingRevocationSignature(keys, subkey, validationDate)) == null) continue;
            this.mostRecentSubkeyRevocations.put(subkey.getKeyID(), bindingRevocation);
        }
    }

    public PGPPublicKey getPublicKey() {
        return this.keys.getPublicKey();
    }

    public PGPPublicKey getPublicKey(OpenPgpV4Fingerprint fingerprint) {
        return this.getPublicKey(fingerprint.getKeyId());
    }

    public PGPPublicKey getPublicKey(long keyId) {
        return this.keys.getPublicKey(keyId);
    }

    public static PGPPublicKey getPublicKey(PGPKeyRing keyRing, long keyId) {
        return keyRing.getPublicKey(keyId);
    }

    public boolean isKeyValidlyBound(long keyId) {
        PGPPublicKey publicKey = this.keys.getPublicKey(keyId);
        if (publicKey == null) {
            return false;
        }
        if (publicKey == this.getPublicKey()) {
            return this.revocationSelfSignature == null;
        }
        PGPSignature binding = this.mostRecentSubkeyBindings.get(keyId);
        PGPSignature revocation = this.mostRecentSubkeyRevocations.get(keyId);
        return binding != null && revocation == null;
    }

    public List<PGPPublicKey> getPublicKeys() {
        Iterator<PGPPublicKey> iterator = this.keys.getPublicKeys();
        List<PGPPublicKey> list = CollectionUtils.iteratorToList(iterator);
        return Collections.unmodifiableList(list);
    }

    public PGPSecretKey getSecretKey() {
        if (this.keys instanceof PGPSecretKeyRing) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)this.keys;
            return secretKeys.getSecretKey();
        }
        return null;
    }

    public PGPSecretKey getSecretKey(OpenPgpV4Fingerprint fingerprint) {
        return this.getSecretKey(fingerprint.getKeyId());
    }

    public PGPSecretKey getSecretKey(long keyId) {
        if (this.keys instanceof PGPSecretKeyRing) {
            return ((PGPSecretKeyRing)this.keys).getSecretKey(keyId);
        }
        return null;
    }

    public List<PGPSecretKey> getSecretKeys() {
        if (this.keys instanceof PGPSecretKeyRing) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)this.keys;
            Iterator<PGPSecretKey> iterator = secretKeys.getSecretKeys();
            return Collections.unmodifiableList(CollectionUtils.iteratorToList(iterator));
        }
        return Collections.emptyList();
    }

    public long getKeyId() {
        return this.getPublicKey().getKeyID();
    }

    public OpenPgpV4Fingerprint getFingerprint() {
        return new OpenPgpV4Fingerprint(this.getPublicKey());
    }

    public String getPrimaryUserId() {
        String primaryUserId = null;
        Date modificationDate = null;
        for (String userId : this.getValidUserIds()) {
            PGPSignature signature = this.mostRecentUserIdSignatures.get(userId);
            PrimaryUserID subpacket = SignatureSubpacketsUtil.getPrimaryUserId(signature);
            if (subpacket == null || !subpacket.isPrimaryUserID() || modificationDate != null && !modificationDate.before(signature.getCreationTime())) continue;
            primaryUserId = userId;
            modificationDate = signature.getCreationTime();
        }
        return primaryUserId;
    }

    public List<String> getUserIds() {
        Iterator<String> iterator = this.getPublicKey().getUserIDs();
        List<String> userIds = CollectionUtils.iteratorToList(iterator);
        return userIds;
    }

    public List<String> getValidUserIds() {
        ArrayList<String> valid = new ArrayList<String>();
        List<String> userIds = this.getUserIds();
        for (String userId : userIds) {
            if (!this.isUserIdValid(userId)) continue;
            valid.add(userId);
        }
        return valid;
    }

    public boolean isUserIdValid(String userId) {
        PGPSignature certification = this.mostRecentUserIdSignatures.get(userId);
        PGPSignature revocation = this.mostRecentUserIdRevocations.get(userId);
        return certification != null && revocation == null;
    }

    public List<String> getEmailAddresses() {
        List<String> userIds = this.getUserIds();
        ArrayList<String> emails = new ArrayList<String>();
        for (String userId : userIds) {
            Matcher matcher = PATTERN_EMAIL.matcher(userId);
            if (!matcher.find()) continue;
            emails.add(matcher.group());
        }
        return emails;
    }

    public PGPSignature getCurrentDirectKeySelfSignature() {
        return this.mostRecentSelfSignature;
    }

    public PGPSignature getRevocationSelfSignature() {
        return this.revocationSelfSignature;
    }

    public PGPSignature getCurrentUserIdCertification(String userId) {
        return this.mostRecentUserIdSignatures.get(userId);
    }

    public PGPSignature getUserIdRevocation(String userId) {
        return this.mostRecentUserIdRevocations.get(userId);
    }

    public PGPSignature getCurrentSubkeyBindingSignature(long keyId) {
        return this.mostRecentSubkeyBindings.get(keyId);
    }

    public PGPSignature getSubkeyRevocationSignature(long keyId) {
        return this.mostRecentSubkeyRevocations.get(keyId);
    }

    public List<KeyFlag> getKeyFlagsOf(long keyId) {
        if (this.getPublicKey().getKeyID() == keyId) {
            KeyFlags flags;
            KeyFlags flags2;
            if (this.mostRecentSelfSignature != null && (flags2 = SignatureSubpacketsUtil.getKeyFlags(this.mostRecentSelfSignature)) != null) {
                return KeyFlag.fromBitmask(flags2.getFlags());
            }
            String primaryUserId = this.getPrimaryUserId();
            if (primaryUserId != null && (flags = SignatureSubpacketsUtil.getKeyFlags(this.mostRecentUserIdSignatures.get(primaryUserId))) != null) {
                return KeyFlag.fromBitmask(flags.getFlags());
            }
        }
        return Collections.emptyList();
    }

    public List<KeyFlag> getKeyFlagsOf(String userId) {
        if (!this.isUserIdValid(userId)) {
            return Collections.emptyList();
        }
        PGPSignature userIdCertification = this.mostRecentUserIdSignatures.get(userId);
        if (userIdCertification == null) {
            return Collections.emptyList();
        }
        KeyFlags keyFlags = SignatureSubpacketsUtil.getKeyFlags(userIdCertification);
        if (keyFlags != null) {
            return KeyFlag.fromBitmask(keyFlags.getFlags());
        }
        return Collections.emptyList();
    }

    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.fromId(this.getPublicKey().getAlgorithm());
    }

    public Date getCreationDate() {
        return this.getPublicKey().getCreationTime();
    }

    public Date getLastModified() {
        PGPSignature mostRecent = this.getMostRecentSignature();
        return mostRecent.getCreationTime();
    }

    private PGPSignature getMostRecentSignature() {
        HashSet<PGPSignature> allSignatures = new HashSet<PGPSignature>();
        if (this.mostRecentSelfSignature != null) {
            allSignatures.add(this.mostRecentSelfSignature);
        }
        if (this.revocationSelfSignature != null) {
            allSignatures.add(this.revocationSelfSignature);
        }
        allSignatures.addAll(this.mostRecentUserIdSignatures.values());
        allSignatures.addAll(this.mostRecentUserIdRevocations.values());
        allSignatures.addAll(this.mostRecentSubkeyBindings.values());
        allSignatures.addAll(this.mostRecentSubkeyRevocations.values());
        PGPSignature mostRecent = null;
        for (PGPSignature signature : allSignatures) {
            if (mostRecent != null && !signature.getCreationTime().after(mostRecent.getCreationTime())) continue;
            mostRecent = signature;
        }
        return mostRecent;
    }

    public Date getRevocationDate() {
        return this.revocationSelfSignature == null ? null : this.revocationSelfSignature.getCreationTime();
    }

    public Date getPrimaryKeyExpirationDate() {
        Date lastExpiration = null;
        if (this.mostRecentSelfSignature != null) {
            lastExpiration = SignatureUtils.getKeyExpirationDate(this.getCreationDate(), this.mostRecentSelfSignature);
        }
        for (String userId : this.getValidUserIds()) {
            PGPSignature signature = this.getCurrentUserIdCertification(userId);
            Date expiration = SignatureUtils.getKeyExpirationDate(this.getCreationDate(), signature);
            if (expiration == null || lastExpiration != null && !expiration.after(lastExpiration)) continue;
            lastExpiration = expiration;
        }
        return lastExpiration;
    }

    public Date getSubkeyExpirationDate(OpenPgpV4Fingerprint fingerprint) {
        if (this.getPublicKey().getKeyID() == fingerprint.getKeyId()) {
            return this.getPrimaryKeyExpirationDate();
        }
        PGPPublicKey subkey = this.getPublicKey(fingerprint.getKeyId());
        if (subkey == null) {
            throw new IllegalArgumentException("No subkey with fingerprint " + fingerprint + " found.");
        }
        return SignatureUtils.getKeyExpirationDate(subkey.getCreationTime(), this.mostRecentSubkeyBindings.get(fingerprint.getKeyId()));
    }

    public boolean isSecretKey() {
        if (this.keys instanceof PGPSecretKeyRing) {
            return true;
        }
        if (this.keys instanceof PGPPublicKeyRing) {
            return false;
        }
        throw new AssertionError((Object)("Expected PGPKeyRing to be either PGPPublicKeyRing or PGPSecretKeyRing, but got " + this.keys.getClass().getName() + " instead."));
    }

    public boolean isFullyDecrypted() {
        if (this.isSecretKey()) {
            for (PGPSecretKey secretKey : this.getSecretKeys()) {
                if (KeyInfo.hasDummyS2K(secretKey) || !KeyInfo.isEncrypted(secretKey)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isFullyEncrypted() {
        if (this.isSecretKey()) {
            for (PGPSecretKey secretKey : this.getSecretKeys()) {
                if (KeyInfo.hasDummyS2K(secretKey) || !KeyInfo.isDecrypted(secretKey)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

