/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.util.NotationRegistry;

public final class Policy {
    private static Policy INSTANCE;
    private HashAlgorithmPolicy signatureHashAlgorithmPolicy = HashAlgorithmPolicy.defaultSignatureAlgorithmPolicy();
    private HashAlgorithmPolicy revocationSignatureHashAlgorithmPolicy = HashAlgorithmPolicy.defaultRevocationSignatureHashAlgorithmPolicy();
    private SymmetricKeyAlgorithmPolicy symmetricKeyEncryptionAlgorithmPolicy = SymmetricKeyAlgorithmPolicy.defaultSymmetricKeyEncryptionAlgorithmPolicy();
    private SymmetricKeyAlgorithmPolicy symmetricKeyDecryptionAlgorithmPolicy = SymmetricKeyAlgorithmPolicy.defaultSymmetricKeyDecryptionAlgorithmPolicy();
    private final NotationRegistry notationRegistry = new NotationRegistry();

    private Policy() {
    }

    public static Policy getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Policy();
        }
        return INSTANCE;
    }

    public HashAlgorithmPolicy getSignatureHashAlgorithmPolicy() {
        return this.signatureHashAlgorithmPolicy;
    }

    public void setSignatureHashAlgorithmPolicy(HashAlgorithmPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("Policy cannot be null.");
        }
        this.signatureHashAlgorithmPolicy = policy;
    }

    public HashAlgorithmPolicy getRevocationSignatureHashAlgorithmPolicy() {
        return this.revocationSignatureHashAlgorithmPolicy;
    }

    public void setRevocationSignatureHashAlgorithmPolicy(HashAlgorithmPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("Policy cannot be null.");
        }
        this.revocationSignatureHashAlgorithmPolicy = policy;
    }

    public SymmetricKeyAlgorithmPolicy getSymmetricKeyEncryptionAlgorithmPolicy() {
        return this.symmetricKeyEncryptionAlgorithmPolicy;
    }

    public SymmetricKeyAlgorithmPolicy getSymmetricKeyDecryptionAlgoritmPolicy() {
        return this.symmetricKeyDecryptionAlgorithmPolicy;
    }

    public void setSymmetricKeyEncryptionAlgorithmPolicy(SymmetricKeyAlgorithmPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("Policy cannot be null.");
        }
        this.symmetricKeyEncryptionAlgorithmPolicy = policy;
    }

    public void setSymmetricKeyDecryptionAlgorithmPolicy(SymmetricKeyAlgorithmPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("Policy cannot be null.");
        }
        this.symmetricKeyDecryptionAlgorithmPolicy = policy;
    }

    public NotationRegistry getNotationRegistry() {
        return this.notationRegistry;
    }

    public static final class HashAlgorithmPolicy {
        private final HashAlgorithm defaultHashAlgorithm;
        private final List<HashAlgorithm> acceptableHashAlgorithms;

        public HashAlgorithmPolicy(HashAlgorithm defaultHashAlgorithm, List<HashAlgorithm> acceptableHashAlgorithms) {
            this.defaultHashAlgorithm = defaultHashAlgorithm;
            this.acceptableHashAlgorithms = Collections.unmodifiableList(acceptableHashAlgorithms);
        }

        public HashAlgorithm defaultHashAlgorithm() {
            return this.defaultHashAlgorithm;
        }

        public boolean isAcceptable(HashAlgorithm hashAlgorithm) {
            return this.acceptableHashAlgorithms.contains((Object)hashAlgorithm);
        }

        public boolean isAcceptable(int algorithmId) {
            HashAlgorithm algorithm = HashAlgorithm.fromId(algorithmId);
            return this.isAcceptable(algorithm);
        }

        public static HashAlgorithmPolicy defaultSignatureAlgorithmPolicy() {
            return new HashAlgorithmPolicy(HashAlgorithm.SHA512, Arrays.asList(HashAlgorithm.SHA224, HashAlgorithm.SHA256, HashAlgorithm.SHA384, HashAlgorithm.SHA512));
        }

        public static HashAlgorithmPolicy defaultRevocationSignatureHashAlgorithmPolicy() {
            return new HashAlgorithmPolicy(HashAlgorithm.SHA512, Arrays.asList(HashAlgorithm.RIPEMD160, HashAlgorithm.SHA1, HashAlgorithm.SHA224, HashAlgorithm.SHA256, HashAlgorithm.SHA384, HashAlgorithm.SHA512));
        }
    }

    public static final class SymmetricKeyAlgorithmPolicy {
        private final SymmetricKeyAlgorithm defaultSymmetricKeyAlgorithm;
        private final List<SymmetricKeyAlgorithm> acceptableSymmetricKeyAlgorithms;

        public SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm defaultSymmetricKeyAlgorithm, List<SymmetricKeyAlgorithm> acceptableSymmetricKeyAlgorithms) {
            this.defaultSymmetricKeyAlgorithm = defaultSymmetricKeyAlgorithm;
            this.acceptableSymmetricKeyAlgorithms = Collections.unmodifiableList(acceptableSymmetricKeyAlgorithms);
        }

        public SymmetricKeyAlgorithm getDefaultSymmetricKeyAlgorithm() {
            return this.defaultSymmetricKeyAlgorithm;
        }

        public boolean isAcceptable(SymmetricKeyAlgorithm algorithm) {
            return this.acceptableSymmetricKeyAlgorithms.contains((Object)algorithm);
        }

        public boolean isAcceptable(int algorithmId) {
            SymmetricKeyAlgorithm algorithm = SymmetricKeyAlgorithm.fromId(algorithmId);
            return this.isAcceptable(algorithm);
        }

        public static SymmetricKeyAlgorithmPolicy defaultSymmetricKeyEncryptionAlgorithmPolicy() {
            return new SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.AES_256, Arrays.asList(SymmetricKeyAlgorithm.BLOWFISH, SymmetricKeyAlgorithm.AES_128, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.TWOFISH, SymmetricKeyAlgorithm.CAMELLIA_128, SymmetricKeyAlgorithm.CAMELLIA_192, SymmetricKeyAlgorithm.CAMELLIA_256));
        }

        public static SymmetricKeyAlgorithmPolicy defaultSymmetricKeyDecryptionAlgorithmPolicy() {
            return new SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.AES_256, Arrays.asList(SymmetricKeyAlgorithm.CAST5, SymmetricKeyAlgorithm.BLOWFISH, SymmetricKeyAlgorithm.AES_128, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.TWOFISH, SymmetricKeyAlgorithm.CAMELLIA_128, SymmetricKeyAlgorithm.CAMELLIA_192, SymmetricKeyAlgorithm.CAMELLIA_256));
        }
    }
}

