/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.cleartext_signatures;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pgpainless.signature.cleartext_signatures.InMemoryMultiPassStrategy;

public interface MultiPassStrategy {
    public OutputStream getMessageOutputStream() throws IOException;

    public InputStream getMessageInputStream() throws IOException;

    public static MultiPassStrategy writeMessageToFile(final File file) {
        return new MultiPassStrategy(){

            @Override
            public OutputStream getMessageOutputStream() throws IOException {
                boolean created;
                if (!file.exists() && !(created = file.createNewFile())) {
                    throw new IOException("New file '" + file.getAbsolutePath() + "' was not created.");
                }
                return new FileOutputStream(file);
            }

            @Override
            public InputStream getMessageInputStream() throws IOException {
                if (!file.exists()) {
                    throw new IOException("File '" + file.getAbsolutePath() + "' does no longer exist.");
                }
                return new FileInputStream(file);
            }
        };
    }

    public static InMemoryMultiPassStrategy keepMessageInMemory() {
        return new InMemoryMultiPassStrategy();
    }
}

