/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop.commands;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeyRingBuilderInterface;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHCurve;
import org.pgpainless.sop.Print;
import picocli.CommandLine;

@CommandLine.Command(name="generate-key", description={"Generate a secret key"}, exitCodeOnInvalidInput=37)
public class GenerateKey
implements Runnable {
    @CommandLine.Option(names={"--no-armor"}, description={"ASCII armor the output"}, negatable=true)
    boolean armor = true;
    @CommandLine.Parameters(description={"User-ID, eg. \"Alice <alice@example.com>\""})
    List<String> userId;

    @Override
    public void run() {
        if (this.userId.isEmpty()) {
            Print.print_ln("At least one user-id expected.");
            System.exit(1);
            return;
        }
        try {
            KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase builder = PGPainless.generateKeyRing().withSubKey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519)).withKeyFlags(KeyFlag.SIGN_DATA).withDefaultAlgorithms()).withSubKey(KeySpec.getBuilder(KeyType.XDH(XDHCurve._X25519)).withKeyFlags(KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE).withDefaultAlgorithms()).withPrimaryKey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519)).withKeyFlags(KeyFlag.CERTIFY_OTHER).withDefaultAlgorithms()).withPrimaryUserId(this.userId.get(0));
            for (int i = 1; i < this.userId.size(); ++i) {
                builder.withAdditionalUserId(this.userId.get(i));
            }
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.add(1, 3);
            Date expiration = calendar.getTime();
            PGPSecretKeyRing secretKeys = builder.setExpirationDate(expiration).withoutPassphrase().build();
            Print.print_ln(Print.toString(secretKeys.getEncoded(), this.armor));
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | PGPException e) {
            Print.err_ln("Error creating OpenPGP key:");
            Print.err_ln(e.getMessage());
            System.exit(1);
        }
    }
}

