/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimeZone;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.sop.Print;
import picocli.CommandLine;

@CommandLine.Command(name="verify", description={"Verify a detached signature over the data from standard input"}, exitCodeOnInvalidInput=37)
public class Verify
implements Runnable {
    private static final TimeZone tz = TimeZone.getTimeZone("UTC");
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
    private static final Date beginningOfTime = new Date(0L);
    private static final Date endOfTime = new Date(8640000000000000L);
    @CommandLine.Parameters(index="0", description={"Detached signature"}, paramLabel="SIGNATURE")
    File signature;
    @CommandLine.Parameters(index="1..*", arity="1..*", description={"Public key certificates"}, paramLabel="CERT")
    File[] certificates;
    @CommandLine.Option(names={"--not-before"}, description={"ISO-8601 formatted UTC date (eg. '2020-11-23T16:35Z)\nReject signatures with a creation date not in range.\nDefaults to beginning of time (\"-\")."}, paramLabel="DATE")
    String notBefore = "-";
    @CommandLine.Option(names={"--not-after"}, description={"ISO-8601 formatted UTC date (eg. '2020-11-23T16:35Z)\nReject signatures with a creation date not in range.\nDefaults to current system time (\"now\").\nAccepts special value \"-\" for end of time."}, paramLabel="DATE")
    String notAfter = "now";

    @Override
    public void run() {
        OpenPgpMetadata metadata;
        Date notBeforeDate = this.parseNotBefore();
        Date notAfterDate = this.parseNotAfter();
        Map<File, PGPPublicKeyRing> publicKeys = this.readCertificatesFromFiles();
        if (publicKeys.isEmpty()) {
            Print.err_ln("No certificates supplied.");
            System.exit(19);
        }
        try (FileInputStream sigIn = new FileInputStream(this.signature);){
            DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream(System.in).doNotDecrypt().verifyDetachedSignature(sigIn).verifyWith(new HashSet<PGPPublicKeyRing>(publicKeys.values())).ignoreMissingPublicKeys().build();
            NullOutputStream out = new NullOutputStream();
            Streams.pipeAll(verifier, out);
            verifier.close();
            metadata = verifier.getResult();
        }
        catch (FileNotFoundException e) {
            Print.err_ln("Signature file not found:");
            Print.err_ln(e.getMessage());
            System.exit(1);
            return;
        }
        catch (IOException | PGPException e) {
            Print.err_ln("Signature validation failed.");
            Print.err_ln(e.getMessage());
            System.exit(1);
            return;
        }
        HashMap<OpenPgpV4Fingerprint, PGPSignature> signaturesInTimeRange = new HashMap<OpenPgpV4Fingerprint, PGPSignature>();
        for (OpenPgpV4Fingerprint fingerprint : metadata.getVerifiedSignatures().keySet()) {
            PGPSignature signature = metadata.getVerifiedSignatures().get(fingerprint);
            Date creationTime = signature.getCreationTime();
            if (creationTime.before(notBeforeDate) || creationTime.after(notAfterDate)) continue;
            signaturesInTimeRange.put(fingerprint, signature);
        }
        if (signaturesInTimeRange.isEmpty()) {
            Print.err_ln("No valid signatures found.");
            System.exit(3);
        }
        this.printValidSignatures(signaturesInTimeRange, publicKeys);
    }

    private void printValidSignatures(Map<OpenPgpV4Fingerprint, PGPSignature> validSignatures, Map<File, PGPPublicKeyRing> publicKeys) {
        for (OpenPgpV4Fingerprint sigKeyFp : validSignatures.keySet()) {
            PGPSignature signature = validSignatures.get(sigKeyFp);
            for (File file : publicKeys.keySet()) {
                PGPPublicKeyRing publicKeyRing = publicKeys.get(file);
                if (publicKeyRing.getPublicKey(sigKeyFp.getKeyId()) == null) continue;
                String utcSigDate = df.format(signature.getCreationTime());
                OpenPgpV4Fingerprint primaryKeyFp = new OpenPgpV4Fingerprint(publicKeyRing);
                Print.print_ln(utcSigDate + " " + sigKeyFp.toString() + " " + primaryKeyFp.toString() + " signed by " + file.getName());
            }
        }
    }

    private Map<File, PGPPublicKeyRing> readCertificatesFromFiles() {
        HashMap<File, PGPPublicKeyRing> publicKeys = new HashMap<File, PGPPublicKeyRing>();
        for (File cert : this.certificates) {
            try (FileInputStream in = new FileInputStream(cert);){
                publicKeys.put(cert, PGPainless.readKeyRing().publicKeyRing(in));
            }
            catch (IOException e) {
                Print.err_ln("Cannot read certificate from file " + cert.getAbsolutePath() + ":");
                Print.err_ln(e.getMessage());
            }
        }
        return publicKeys;
    }

    private Date parseNotAfter() {
        try {
            return this.notAfter.equals("now") ? new Date() : (this.notAfter.equals("-") ? endOfTime : df.parse(this.notAfter));
        }
        catch (ParseException e) {
            Print.err_ln("Invalid date string supplied as value of --not-after.");
            System.exit(1);
            return null;
        }
    }

    private Date parseNotBefore() {
        try {
            return this.notBefore.equals("now") ? new Date() : (this.notBefore.equals("-") ? beginningOfTime : df.parse(this.notBefore));
        }
        catch (ParseException e) {
            Print.err_ln("Invalid date string supplied as value of --not-before.");
            System.exit(1);
            return null;
        }
    }

    static {
        df.setTimeZone(tz);
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

