/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.key;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.signature.SelectSignatureFromKey;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.util.CollectionUtils;

public abstract class SelectPublicKey {
    private static final Logger LOGGER = Logger.getLogger(SelectPublicKey.class.getName());

    public abstract boolean accept(PGPPublicKey var1, PGPKeyRing var2);

    public List<PGPPublicKey> selectPublicKeys(PGPKeyRing keyRing) {
        ArrayList<PGPPublicKey> selected = new ArrayList<PGPPublicKey>();
        List<PGPPublicKey> publicKeys = CollectionUtils.iteratorToList(keyRing.getPublicKeys());
        for (PGPPublicKey publicKey : publicKeys) {
            if (!this.accept(publicKey, keyRing)) continue;
            selected.add(publicKey);
        }
        return selected;
    }

    public PGPPublicKey firstMatch(PGPKeyRing keyRing) {
        List<PGPPublicKey> selected = this.selectPublicKeys(keyRing);
        if (selected.isEmpty()) {
            return null;
        }
        return selected.get(0);
    }

    public static SelectPublicKey isPrimaryKey() {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                return publicKey.isMasterKey() && keyRing.getPublicKey().getKeyID() == publicKey.getKeyID();
            }
        };
    }

    public static SelectPublicKey isSubKey() {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                if (2.isPrimaryKey().accept(publicKey, keyRing)) {
                    return false;
                }
                PGPPublicKey primaryKey = keyRing.getPublicKey();
                SelectSignatureFromKey bindingSigSelector = SelectSignatureFromKey.isValidSubkeyBindingSignature(primaryKey, publicKey);
                Iterator bindingSigs = publicKey.getSignaturesOfType(SignatureType.SUBKEY_BINDING.getCode());
                while (bindingSigs.hasNext()) {
                    if (!bindingSigSelector.accept((PGPSignature)bindingSigs.next(), publicKey, keyRing)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static SelectPublicKey validForUserId(String userId) {
        return SelectPublicKey.validForUserId(userId, new Date());
    }

    public static SelectPublicKey validForUserId(final String userId, final Date validationDate) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                PGPPublicKey primaryKey = keyRing.getPublicKey();
                List<String> userIds = CollectionUtils.iteratorToList(primaryKey.getUserIDs());
                if (!userIds.contains(userId)) {
                    LOGGER.log(Level.INFO, "Keyring " + Long.toHexString(primaryKey.getKeyID()) + " does not contain user-id '" + userId + "'");
                }
                if (3.isRevoked(validationDate).accept(primaryKey, keyRing)) {
                    LOGGER.log(Level.INFO, "Primary key " + Long.toHexString(primaryKey.getKeyID()) + " has been revoked.");
                    return false;
                }
                if (3.isExpired(userId, validationDate).accept(primaryKey, keyRing)) {
                    LOGGER.log(Level.INFO, "Primary key " + Long.toHexString(primaryKey.getKeyID()) + " has expired.");
                    return false;
                }
                if (3.isUserIdRevoked(userId, validationDate).accept(primaryKey, keyRing)) {
                    LOGGER.log(Level.INFO, "Primary key " + Long.toHexString(primaryKey.getKeyID()) + " has been revoked.");
                }
                try {
                    boolean userIdValid = SignatureUtils.isUserIdValid(primaryKey, userId);
                    if (!userIdValid) {
                        LOGGER.log(Level.INFO, "User-id '" + userId + "' is not valid for key " + Long.toHexString(primaryKey.getKeyID()));
                        return false;
                    }
                }
                catch (PGPException e) {
                    LOGGER.log(Level.INFO, "Could not verify signature on primary key " + Long.toHexString(primaryKey.getKeyID()) + " and user-id '" + userId + "'", e);
                    return false;
                }
                if (publicKey == primaryKey) {
                    return true;
                }
                if (!3.isSubKey().accept(publicKey, keyRing)) {
                    LOGGER.log(Level.INFO, "Key " + Long.toHexString(publicKey.getKeyID()) + " is not valid subkey of key " + Long.toHexString(primaryKey.getKeyID()));
                    return false;
                }
                if (3.isRevoked(validationDate).accept(publicKey, keyRing)) {
                    LOGGER.log(Level.INFO, "Subkey " + Long.toHexString(publicKey.getKeyID()) + " of key " + Long.toHexString(primaryKey.getKeyID()) + " is revoked");
                    return false;
                }
                return true;
            }
        };
    }

    public static SelectPublicKey isRevoked(Date validationDate) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                if (publicKey.isMasterKey()) {
                    Iterator revSigIt;
                    List<PGPSignature> revSigs;
                    if (!publicKey.hasRevocation()) {
                        return false;
                    }
                    SelectSignatureFromKey validRevocation = SelectSignatureFromKey.isValidKeyRevocationSignature(publicKey);
                    List<PGPSignature> validRevSigs = validRevocation.select(revSigs = CollectionUtils.iteratorToList(revSigIt = publicKey.getSignaturesOfType(SignatureType.KEY_REVOCATION.getCode())), publicKey, keyRing);
                    return !validRevSigs.isEmpty();
                }
                return publicKey.hasRevocation() || keyRing.getPublicKey().hasRevocation();
            }
        };
    }

    public static SelectPublicKey isExpired(String userId, Date validationDate) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                return false;
            }
        };
    }

    public static SelectPublicKey isUserIdRevoked(String userId, Date validationDate) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                return false;
            }
        };
    }

    private static SelectPublicKey hasKeyRevocationSignature() {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                Iterator it = publicKey.getSignatures();
                while (it.hasNext()) {
                    PGPSignature signature = (PGPSignature)it.next();
                    if (!SelectSignatureFromKey.isValidKeyRevocationSignature(publicKey).accept(signature, publicKey, keyRing)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static SelectPublicKey hasSubkeyRevocationSignature() {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                Iterator it = publicKey.getKeySignatures();
                while (it.hasNext()) {
                    PGPSignature signature = (PGPSignature)it.next();
                    if (!SelectSignatureFromKey.isValidSubkeyRevocationSignature(publicKey, keyRing.getPublicKey()).accept(signature, publicKey, keyRing)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static SelectPublicKey isSubkeyOfRevokedPrimaryKey() {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                return 9.isSubKey().accept(publicKey, keyRing) && SelectPublicKey.hasKeyRevocationSignature().accept(keyRing.getPublicKey(), keyRing);
            }
        };
    }

    public static SelectPublicKey hasKeyFlag(String userId, KeyFlag keyFlag) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                return false;
            }
        };
    }

    public static SelectPublicKey supportsAlgorithm(SymmetricKeyAlgorithm symmetricKeyAlgorithm) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                return false;
            }
        };
    }

    public static SelectPublicKey supportsAlgorithm(HashAlgorithm hashAlgorithm) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                return false;
            }
        };
    }

    public static SelectPublicKey supportsAlgorithm(CompressionAlgorithm compressionAlgorithm) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                return false;
            }
        };
    }

    public static SelectPublicKey and(final SelectPublicKey ... selectors) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                for (SelectPublicKey selector : selectors) {
                    if (selector.accept(publicKey, keyRing)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static SelectPublicKey or(final SelectPublicKey ... selectors) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                boolean accept = false;
                for (SelectPublicKey selector : selectors) {
                    accept |= selector.accept(publicKey, keyRing);
                }
                return accept;
            }
        };
    }

    public static SelectPublicKey not(final SelectPublicKey selector) {
        return new SelectPublicKey(){

            @Override
            public boolean accept(PGPPublicKey publicKey, PGPKeyRing keyRing) {
                return !selector.accept(publicKey, keyRing);
            }
        };
    }
}

