/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.DetachedSignature;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.util.Passphrase;

public final class EncryptionStream
extends OutputStream {
    private static final Logger LOGGER = Logger.getLogger(EncryptionStream.class.getName());
    private static final Level LEVEL = Level.FINE;
    private static final int BUFFER_SIZE = 256;
    private final SymmetricKeyAlgorithm symmetricKeyAlgorithm;
    private final HashAlgorithm hashAlgorithm;
    private final CompressionAlgorithm compressionAlgorithm;
    private final Set<PGPPublicKey> encryptionKeys;
    private final Set<Passphrase> encryptionPassphrases;
    private final boolean detachedSignature;
    private final SignatureType signatureType;
    private final Map<OpenPgpV4Fingerprint, PGPPrivateKey> signingKeys;
    private final boolean asciiArmor;
    private final OpenPgpMetadata.Builder resultBuilder = OpenPgpMetadata.getBuilder();
    private Map<OpenPgpV4Fingerprint, PGPSignatureGenerator> signatureGenerators = new ConcurrentHashMap<OpenPgpV4Fingerprint, PGPSignatureGenerator>();
    private boolean closed = false;
    OutputStream outermostStream = null;
    private ArmoredOutputStream armorOutputStream = null;
    private OutputStream publicKeyEncryptedStream = null;
    private PGPCompressedDataGenerator compressedDataGenerator;
    private BCPGOutputStream basicCompressionStream;
    private PGPLiteralDataGenerator literalDataGenerator;
    private OutputStream literalDataStream;

    EncryptionStream(@Nonnull OutputStream targetOutputStream, @Nonnull Set<PGPPublicKey> encryptionKeys, @Nonnull Set<Passphrase> encryptionPassphrases, boolean detachedSignature, SignatureType signatureType, @Nonnull Map<OpenPgpV4Fingerprint, PGPPrivateKey> signingKeys, @Nonnull SymmetricKeyAlgorithm symmetricKeyAlgorithm, @Nonnull HashAlgorithm hashAlgorithm, @Nonnull CompressionAlgorithm compressionAlgorithm, boolean asciiArmor) throws IOException, PGPException {
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
        this.encryptionKeys = Collections.unmodifiableSet(encryptionKeys);
        this.encryptionPassphrases = Collections.unmodifiableSet(encryptionPassphrases);
        this.detachedSignature = detachedSignature;
        this.signatureType = signatureType;
        this.signingKeys = Collections.unmodifiableMap(signingKeys);
        this.asciiArmor = asciiArmor;
        this.outermostStream = targetOutputStream;
        this.prepareArmor();
        this.prepareEncryption();
        this.prepareSigning();
        this.prepareCompression();
        this.prepareOnePassSignatures();
        this.prepareLiteralDataProcessing();
        this.prepareResultBuilder();
    }

    private void prepareArmor() {
        if (!this.asciiArmor) {
            LOGGER.log(LEVEL, "Encryption output will be binary");
            return;
        }
        LOGGER.log(LEVEL, "Wrap encryption output in ASCII armor");
        this.armorOutputStream = new ArmoredOutputStream(this.outermostStream);
        this.outermostStream = this.armorOutputStream;
    }

    private void prepareEncryption() throws IOException, PGPException {
        if (this.encryptionKeys.isEmpty() && this.encryptionPassphrases.isEmpty()) {
            return;
        }
        LOGGER.log(LEVEL, "At least one encryption key is available -> encrypt using " + (Object)((Object)this.symmetricKeyAlgorithm));
        PGPDataEncryptorBuilder dataEncryptorBuilder = ImplementationFactory.getInstance().getPGPDataEncryptorBuilder(this.symmetricKeyAlgorithm);
        if (dataEncryptorBuilder instanceof BcPGPDataEncryptorBuilder) {
            ((BcPGPDataEncryptorBuilder)dataEncryptorBuilder).setWithIntegrityPacket(true);
        } else if (dataEncryptorBuilder instanceof JcePGPDataEncryptorBuilder) {
            ((JcePGPDataEncryptorBuilder)dataEncryptorBuilder).setWithIntegrityPacket(true);
        }
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(dataEncryptorBuilder);
        for (PGPPublicKey key : this.encryptionKeys) {
            LOGGER.log(LEVEL, "Encrypt for key " + Long.toHexString(key.getKeyID()));
            PublicKeyKeyEncryptionMethodGenerator keyEncryption = ImplementationFactory.getInstance().getPublicKeyKeyEncryptionMethodGenerator(key);
            encryptedDataGenerator.addMethod(keyEncryption);
        }
        for (Passphrase passphrase : this.encryptionPassphrases) {
            PBEKeyEncryptionMethodGenerator passphraseEncryption = ImplementationFactory.getInstance().getPBEKeyEncryptionMethodGenerator(passphrase);
            encryptedDataGenerator.addMethod(passphraseEncryption);
        }
        this.outermostStream = this.publicKeyEncryptedStream = encryptedDataGenerator.open(this.outermostStream, new byte[256]);
    }

    private void prepareSigning() throws PGPException {
        if (this.signingKeys.isEmpty()) {
            return;
        }
        LOGGER.log(LEVEL, "At least one signing key is available -> sign " + (Object)((Object)this.hashAlgorithm) + " hash of message");
        for (OpenPgpV4Fingerprint fingerprint : this.signingKeys.keySet()) {
            PGPPrivateKey privateKey = this.signingKeys.get(fingerprint);
            LOGGER.log(LEVEL, "Sign using key " + fingerprint);
            PGPContentSignerBuilder contentSignerBuilder = ImplementationFactory.getInstance().getPGPContentSignerBuilder(privateKey.getPublicKeyPacket().getAlgorithm(), this.hashAlgorithm.getAlgorithmId());
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(contentSignerBuilder);
            signatureGenerator.init(this.signatureType.getCode(), privateKey);
            this.signatureGenerators.put(fingerprint, signatureGenerator);
        }
    }

    private void prepareCompression() throws IOException {
        LOGGER.log(LEVEL, "Compress using " + (Object)((Object)this.compressionAlgorithm));
        this.compressedDataGenerator = new PGPCompressedDataGenerator(this.compressionAlgorithm.getAlgorithmId());
        this.basicCompressionStream = new BCPGOutputStream(this.compressedDataGenerator.open(this.outermostStream));
    }

    private void prepareOnePassSignatures() throws IOException, PGPException {
        for (PGPSignatureGenerator signatureGenerator : this.signatureGenerators.values()) {
            signatureGenerator.generateOnePassVersion(false).encode(this.basicCompressionStream);
        }
    }

    private void prepareLiteralDataProcessing() throws IOException {
        this.literalDataGenerator = new PGPLiteralDataGenerator();
        this.literalDataStream = this.literalDataGenerator.open((OutputStream)this.basicCompressionStream, 'b', "_CONSOLE", new Date(), new byte[256]);
    }

    private void prepareResultBuilder() {
        for (PGPPublicKey recipient : this.encryptionKeys) {
            this.resultBuilder.addRecipientKeyId(recipient.getKeyID());
        }
        this.resultBuilder.setSymmetricKeyAlgorithm(this.symmetricKeyAlgorithm);
        this.resultBuilder.setCompressionAlgorithm(this.compressionAlgorithm);
    }

    @Override
    public void write(int data) throws IOException {
        this.literalDataStream.write(data);
        for (PGPSignatureGenerator signatureGenerator : this.signatureGenerators.values()) {
            byte asByte = (byte)(data & 0xFF);
            signatureGenerator.update(asByte);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        this.literalDataStream.write(buffer, 0, len);
        for (PGPSignatureGenerator signatureGenerator : this.signatureGenerators.values()) {
            signatureGenerator.update(buffer, 0, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.literalDataStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.literalDataStream.flush();
        this.literalDataStream.close();
        this.literalDataGenerator.close();
        this.writeSignatures();
        this.compressedDataGenerator.close();
        if (this.publicKeyEncryptedStream != null) {
            this.publicKeyEncryptedStream.flush();
            this.publicKeyEncryptedStream.close();
        }
        if (this.armorOutputStream != null) {
            this.armorOutputStream.flush();
            this.armorOutputStream.close();
        }
        this.closed = true;
    }

    private void writeSignatures() throws IOException {
        for (OpenPgpV4Fingerprint fingerprint : this.signatureGenerators.keySet()) {
            PGPSignatureGenerator signatureGenerator = this.signatureGenerators.get(fingerprint);
            try {
                PGPSignature signature = signatureGenerator.generate();
                if (!this.detachedSignature) {
                    signature.encode(this.basicCompressionStream);
                }
                this.resultBuilder.addDetachedSignature(new DetachedSignature(signature, fingerprint));
            }
            catch (PGPException e) {
                throw new IOException(e);
            }
        }
    }

    public OpenPgpMetadata getResult() {
        if (!this.closed) {
            throw new IllegalStateException("EncryptionStream must be closed before accessing the Result.");
        }
        return this.resultBuilder.build();
    }

    public static enum Purpose {
        COMMUNICATIONS,
        STORAGE,
        STORAGE_AND_COMMUNICATIONS;

    }
}

