/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class KeyRingInfo {
    private static final Pattern PATTERN_EMAIL = Pattern.compile("[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,6}");
    private final PGPKeyRing keys;

    public KeyRingInfo(PGPKeyRing keys) {
        this.keys = keys;
    }

    public PGPPublicKey getPublicKey() {
        return this.keys.getPublicKey();
    }

    public List<PGPPublicKey> getPublicKeys() {
        ArrayList<PGPPublicKey> list = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKey> iterator = this.keys.getPublicKeys();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return Collections.unmodifiableList(list);
    }

    public PGPSecretKey getSecretKey() {
        if (this.keys instanceof PGPSecretKeyRing) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)this.keys;
            return secretKeys.getSecretKey();
        }
        return null;
    }

    public List<PGPSecretKey> getSecretKeys() {
        ArrayList<PGPSecretKey> list = new ArrayList<PGPSecretKey>();
        if (this.keys instanceof PGPSecretKeyRing) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)this.keys;
            Iterator<PGPSecretKey> iterator = secretKeys.getSecretKeys();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
        return Collections.unmodifiableList(list);
    }

    public long getKeyId() {
        return this.getPublicKey().getKeyID();
    }

    public OpenPgpV4Fingerprint getFingerprint() {
        return new OpenPgpV4Fingerprint(this.getPublicKey());
    }

    public List<String> getUserIds() {
        ArrayList<String> userIds = new ArrayList<String>();
        Iterator<String> iterator = this.getPublicKey().getUserIDs();
        while (iterator.hasNext()) {
            userIds.add(iterator.next());
        }
        return userIds;
    }

    public List<String> getEmailAddresses() {
        List<String> userIds = this.getUserIds();
        ArrayList<String> emails = new ArrayList<String>();
        for (String userId : userIds) {
            Matcher matcher = PATTERN_EMAIL.matcher(userId);
            if (!matcher.find()) continue;
            emails.add(matcher.group());
        }
        return emails;
    }

    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.fromId(this.getPublicKey().getAlgorithm());
    }

    public Date getCreationDate() {
        return this.getPublicKey().getCreationTime();
    }

    public Date getLastModified() {
        Iterator signatures = this.getPublicKey().getSignatures();
        long last = 0L;
        while (signatures.hasNext()) {
            PGPSignature signature = (PGPSignature)signatures.next();
            if (this.getKeyId() != signature.getKeyID()) continue;
            last = Math.max(last, signature.getCreationTime().getTime());
        }
        return new Date(last);
    }

    public Date getRevocationDate() {
        Iterator revocations = this.getPublicKey().getSignaturesOfType(SignatureType.KEY_REVOCATION.getCode());
        while (revocations.hasNext()) {
            PGPSignature revocation = (PGPSignature)revocations.next();
            if (this.getKeyId() != revocation.getKeyID()) continue;
            return revocation.getCreationTime();
        }
        return null;
    }

    public Date getExpirationDate() {
        long validSeconds = this.getPublicKey().getValidSeconds();
        if (validSeconds == 0L) {
            return null;
        }
        return new Date(this.getCreationDate().getTime() + 1000L * validSeconds);
    }

    public boolean isSecretKey() {
        if (this.keys instanceof PGPSecretKeyRing) {
            return true;
        }
        if (this.keys instanceof PGPPublicKeyRing) {
            return false;
        }
        throw new AssertionError((Object)("Expected PGPKeyRing to be either PGPPublicKeyRing or PGPSecretKeyRing, but got " + this.keys.getClass().getName() + " instead."));
    }

    public boolean isFullyDecrypted() {
        if (this.isSecretKey()) {
            for (PGPSecretKey secretKey : this.getSecretKeys()) {
                if (secretKey.getKeyEncryptionAlgorithm() == SymmetricKeyAlgorithm.NULL.getAlgorithmId()) continue;
                return false;
            }
        }
        return true;
    }
}

