/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.keyring;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.pgpainless.key.selection.keyring.KeyRingSelectionStrategy;
import org.pgpainless.util.MultiMap;

public abstract class PublicKeyRingSelectionStrategy<O>
implements KeyRingSelectionStrategy<PGPPublicKeyRing, PGPPublicKeyRingCollection, O> {
    @Override
    public Set<PGPPublicKeyRing> selectKeyRingsFromCollection(@Nonnull O identifier, @Nonnull PGPPublicKeyRingCollection keyRingCollection) {
        HashSet<PGPPublicKeyRing> accepted = new HashSet<PGPPublicKeyRing>();
        Iterator<PGPPublicKeyRing> i = keyRingCollection.getKeyRings();
        while (i.hasNext()) {
            PGPPublicKeyRing ring = i.next();
            if (!this.accept(identifier, ring)) continue;
            accepted.add(ring);
        }
        return accepted;
    }

    @Override
    public MultiMap<O, PGPPublicKeyRing> selectKeyRingsFromCollections(@Nonnull MultiMap<O, PGPPublicKeyRingCollection> keyRingCollections) {
        MultiMap<O, PGPPublicKeyRing> keyRings = new MultiMap<O, PGPPublicKeyRing>();
        for (O identifier : keyRingCollections.keySet()) {
            for (PGPPublicKeyRingCollection collection : keyRingCollections.get(identifier)) {
                keyRings.put(identifier, this.selectKeyRingsFromCollection(identifier, collection));
            }
        }
        return keyRings;
    }
}

