/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.keyring;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.pgpainless.key.selection.keyring.KeyRingSelectionStrategy;
import org.pgpainless.util.MultiMap;

public abstract class SecretKeyRingSelectionStrategy<O>
implements KeyRingSelectionStrategy<PGPSecretKeyRing, PGPSecretKeyRingCollection, O> {
    @Override
    public Set<PGPSecretKeyRing> selectKeyRingsFromCollection(O identifier, @Nonnull PGPSecretKeyRingCollection keyRingCollection) {
        HashSet<PGPSecretKeyRing> accepted = new HashSet<PGPSecretKeyRing>();
        Iterator<PGPSecretKeyRing> i = keyRingCollection.getKeyRings();
        while (i.hasNext()) {
            PGPSecretKeyRing ring = i.next();
            if (!this.accept(identifier, ring)) continue;
            accepted.add(ring);
        }
        return accepted;
    }

    @Override
    public MultiMap<O, PGPSecretKeyRing> selectKeyRingsFromCollections(@Nonnull MultiMap<O, PGPSecretKeyRingCollection> keyRingCollections) {
        MultiMap<O, PGPSecretKeyRing> keyRings = new MultiMap<O, PGPSecretKeyRing>();
        for (O identifier : keyRingCollections.keySet()) {
            for (PGPSecretKeyRingCollection collection : keyRingCollections.get(identifier)) {
                keyRings.put(identifier, this.selectKeyRingsFromCollection(identifier, collection));
            }
        }
        return keyRings;
    }
}

