/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

public class UserId
implements CharSequence {
    private final String name;
    private final String comment;
    private final String email;

    public UserId(String name, String comment, String email) {
        this.name = name;
        this.comment = comment;
        this.email = email;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
        }
        if (this.comment != null) {
            sb.append(" (").append(this.comment).append(')');
        }
        if (this.email != null) {
            sb.append(sb.length() != 0 ? " <" : Character.valueOf('<')).append(this.email).append('>');
        }
        return sb.toString();
    }

    public static UserId onlyEmail(String email) {
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
        return new UserId(null, null, email);
    }

    public static WithComment withName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        return new WithComment(name);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int i) {
        return this.toString().charAt(i);
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        return this.toString().subSequence(i, i1);
    }

    public static class WithEmail {
        private final String name;
        private final String comment;

        public WithEmail(String name, String comment) {
            this.name = name;
            this.comment = comment;
        }

        public UserId withEmail(String email) {
            if (email == null) {
                throw new IllegalArgumentException("Email must not be null.");
            }
            return new UserId(this.name, this.comment, email);
        }

        public UserId noEmail() {
            return new UserId(this.name, this.comment, null);
        }
    }

    public static class WithComment {
        private final String name;

        public WithComment(String name) {
            this.name = name;
        }

        public WithEmail withComment(String comment) {
            if (comment == null) {
                throw new IllegalArgumentException("Comment must not be null.");
            }
            return new WithEmail(this.name, comment);
        }

        public WithEmail noComment() {
            return new WithEmail(this.name, null);
        }

        public UserId build() {
            return new UserId(this.name, null, null);
        }
    }
}

