/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.PGPainless;
import org.pgpainless.sop.Print;

public class SopKeyUtil {
    public static List<PGPSecretKeyRing> loadKeysFromFiles(File ... files) throws IOException, PGPException {
        ArrayList<PGPSecretKeyRing> secretKeyRings = new ArrayList<PGPSecretKeyRing>();
        for (File file : files) {
            try (FileInputStream in = new FileInputStream(file);){
                secretKeyRings.add(PGPainless.readKeyRing().secretKeyRing(in));
            }
            catch (IOException | PGPException e) {
                Print.err_ln("Could not load secret key " + file.getName() + ": " + e.getMessage());
                throw e;
            }
        }
        return secretKeyRings;
    }
}

