/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop.commands;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.PGPainless;
import org.pgpainless.sop.Print;
import picocli.CommandLine;

@CommandLine.Command(name="generate-key", description={"Generate a secret key"})
public class GenerateKey
implements Runnable {
    @CommandLine.Option(names={"--no-armor"}, description={"ASCII armor the output"}, negatable=true)
    boolean armor = true;
    @CommandLine.Parameters(description={"User-ID, eg. \"Alice <alice@example.com>\""})
    String userId;

    @Override
    public void run() {
        try {
            PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing(this.userId);
            Print.print_ln(Print.toString(secretKeys.getEncoded(), this.armor));
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | PGPException e) {
            Print.err_ln("Error creating OpenPGP key:");
            Print.err_ln(e.getMessage());
            System.exit(1);
        }
    }
}

