/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum HashAlgorithm {
    MD5(1),
    SHA1(2),
    RIPEMD160(3),
    DOUBLE_SHA(4),
    MD2(5),
    TIGER_192(6),
    HAVAL_5_160(7),
    SHA256(8),
    SHA384(9),
    SHA512(10),
    SHA224(11);

    private static final Map<Integer, HashAlgorithm> MAP;
    private final int algorithmId;

    public static HashAlgorithm fromId(int id) {
        return MAP.get(id);
    }

    private HashAlgorithm(int id) {
        this.algorithmId = id;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    static {
        MAP = new ConcurrentHashMap<Integer, HashAlgorithm>();
        for (HashAlgorithm h : HashAlgorithm.values()) {
            MAP.put(h.algorithmId, h);
        }
    }
}

