/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type;

import java.security.spec.AlgorithmParameterSpec;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.ecc.ecdh.ECDH;
import org.pgpainless.key.generation.type.ecc.ecdsa.ECDSA;
import org.pgpainless.key.generation.type.eddsa.EdDSA;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.rsa.RSA;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh.XDH;
import org.pgpainless.key.generation.type.xdh.XDHCurve;

public interface KeyType {
    public String getName();

    public PublicKeyAlgorithm getAlgorithm();

    public AlgorithmParameterSpec getAlgorithmSpec();

    public boolean canSign();

    default public boolean canCertify() {
        return this.canSign();
    }

    default public boolean canAuthenticate() {
        return this.canSign();
    }

    public boolean canEncryptCommunication();

    default public boolean canEncryptStorage() {
        return this.canEncryptCommunication();
    }

    public static KeyType RSA(RsaLength length) {
        return RSA.withLength(length);
    }

    public static KeyType ECDH(EllipticCurve curve) {
        return ECDH.fromCurve(curve);
    }

    public static KeyType ECDSA(EllipticCurve curve) {
        return ECDSA.fromCurve(curve);
    }

    public static KeyType EDDSA(EdDSACurve curve) {
        return EdDSA.fromCurve(curve);
    }

    public static KeyType XDH(XDHCurve curve) {
        return XDH.fromCurve(curve);
    }
}

