/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type.eddsa;

import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;

public final class EdDSA
implements KeyType {
    private final EdDSACurve curve;

    private EdDSA(EdDSACurve curve) {
        this.curve = curve;
    }

    public static EdDSA fromCurve(EdDSACurve curve) {
        return new EdDSA(curve);
    }

    @Override
    public String getName() {
        return "EdDSA";
    }

    @Override
    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.EDDSA;
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmSpec() {
        return new ECNamedCurveGenParameterSpec(this.curve.getName());
    }

    @Override
    public boolean canSign() {
        return true;
    }

    @Override
    public boolean canEncryptCommunication() {
        return false;
    }
}

