/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type.xdh;

import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.xdh.XDHCurve;

public final class XDH
implements KeyType {
    private final XDHCurve curve;

    private XDH(XDHCurve curve) {
        this.curve = curve;
    }

    public static XDH fromCurve(XDHCurve curve) {
        return new XDH(curve);
    }

    @Override
    public String getName() {
        return "XDH";
    }

    @Override
    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.ECDH;
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmSpec() {
        return new ECNamedCurveGenParameterSpec(this.curve.getName());
    }

    @Override
    public boolean canSign() {
        return false;
    }

    @Override
    public boolean canEncryptCommunication() {
        return true;
    }
}

