/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.key.impl;

import java.util.Iterator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.selection.key.PublicKeySelectionStrategy;
import org.pgpainless.key.selection.key.SecretKeySelectionStrategy;

public class HasAllKeyFlagSelectionStrategy {

    public static class SecretKey
    extends SecretKeySelectionStrategy {
        private final int keyFlagMask;

        public SecretKey(KeyFlag ... flags) {
            this(KeyFlag.toBitmask(flags));
        }

        public SecretKey(int mask) {
            this.keyFlagMask = mask;
        }

        @Override
        public boolean accept(PGPSecretKey key) {
            Iterator signatures = key.getPublicKey().getSignatures();
            int flags = ((PGPSignature)signatures.next()).getHashedSubPackets().getKeyFlags();
            return (this.keyFlagMask & flags) == this.keyFlagMask;
        }
    }

    public static class PublicKey
    extends PublicKeySelectionStrategy {
        private final int keyFlagMask;

        public PublicKey(KeyFlag ... flags) {
            this(KeyFlag.toBitmask(flags));
        }

        public PublicKey(int mask) {
            this.keyFlagMask = mask;
        }

        @Override
        public boolean accept(PGPPublicKey key) {
            Iterator signatures = key.getSignatures();
            int flags = ((PGPSignature)signatures.next()).getHashedSubPackets().getKeyFlags();
            return (this.keyFlagMask & flags) == this.keyFlagMask;
        }
    }
}

