/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;

public class OpenPgpKeyAttributeUtil {
    public static List<HashAlgorithm> getPreferredHashAlgorithms(PGPPublicKey publicKey) {
        ArrayList<HashAlgorithm> hashAlgorithms = new ArrayList<HashAlgorithm>();
        Iterator keySignatures = publicKey.getSignatures();
        while (keySignatures.hasNext()) {
            int[] hashAlgos;
            SignatureType signatureType;
            PGPSignature signature = (PGPSignature)keySignatures.next();
            if (signature.getKeyID() != publicKey.getKeyID() || (signatureType = SignatureType.valueOf(signature.getSignatureType())) != SignatureType.POSITIVE_CERTIFICATION && signatureType != SignatureType.GENERIC_CERTIFICATION) continue;
            for (int h : hashAlgos = signature.getHashedSubPackets().getPreferredHashAlgorithms()) {
                hashAlgorithms.add(HashAlgorithm.fromId(h));
            }
        }
        return hashAlgorithms;
    }
}

