/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.util.List;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.key.util.OpenPgpKeyAttributeUtil;

public class SignatureUtils {
    public static PGPSignatureGenerator getSignatureGeneratorFor(PGPSecretKey singingKey) {
        return SignatureUtils.getSignatureGeneratorFor(singingKey.getPublicKey());
    }

    public static PGPSignatureGenerator getSignatureGeneratorFor(PGPPublicKey signingPubKey) {
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(SignatureUtils.getPgpContentSignerBuilderForKey(signingPubKey));
        return signatureGenerator;
    }

    private static BcPGPContentSignerBuilder getPgpContentSignerBuilderForKey(PGPPublicKey publicKey) {
        List<HashAlgorithm> preferredHashAlgorithms = OpenPgpKeyAttributeUtil.getPreferredHashAlgorithms(publicKey);
        HashAlgorithm hashAlgorithm = SignatureUtils.negotiateHashAlgorithm(preferredHashAlgorithms);
        return new BcPGPContentSignerBuilder(publicKey.getAlgorithm(), hashAlgorithm.getAlgorithmId());
    }

    private static HashAlgorithm negotiateHashAlgorithm(List<HashAlgorithm> preferredHashAlgorithms) {
        return preferredHashAlgorithms.get(0);
    }
}

