/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop.commands;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.sop.Print;
import picocli.CommandLine;

@CommandLine.Command(name="armor", description={"Add ASCII Armor to standard input"})
public class Armor
implements Runnable {
    private static final byte[] BEGIN_ARMOR = "-----BEGIN PGP".getBytes(StandardCharsets.UTF_8);
    @CommandLine.Option(names={"--label"}, description={"Label to be used in the header and tail of the armoring."}, paramLabel="{auto|sig|key|cert|message}")
    Label label;
    @CommandLine.Option(names={"--allow-nested"}, description={"Allow additional armoring of already armored input"})
    boolean allowNested = false;

    @Override
    public void run() {
        try (PushbackInputStream pbIn = new PushbackInputStream(System.in);
             ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(System.out);){
            byte[] start = new byte[14];
            int read = pbIn.read(start);
            pbIn.unread(read);
            if (Arrays.equals(BEGIN_ARMOR, start) && !this.allowNested) {
                Streams.pipeAll(pbIn, System.out);
            } else {
                Streams.pipeAll(pbIn, armoredOutputStream);
            }
        }
        catch (IOException e) {
            Print.err_ln("Input data cannot be ASCII armored.");
            Print.err_ln(e.getMessage());
            System.exit(1);
        }
    }

    private static enum Label {
        auto,
        sig,
        key,
        cert,
        message;

    }
}

