/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop.commands;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.pgpainless.PGPainless;
import org.pgpainless.sop.Print;
import org.pgpainless.sop.SopKeyUtil;
import picocli.CommandLine;

@CommandLine.Command(name="decrypt", description={"Decrypt a message from standard input"})
public class Decrypt
implements Runnable {
    @CommandLine.Option(names={"--session-key-out"}, description={"Can be used to learn the session key on successful decryption"}, paramLabel="SESSIONKEY")
    File sessionKeyOut;
    @CommandLine.Option(names={"--with-session-key"}, description={"Enables decryption of the \"CIPHERTEXT\" using the session key directly against the \"SEIPD\" packet"}, paramLabel="SESSIONKEY")
    File[] withSessionKey;
    @CommandLine.Option(names={"--with-password"}, description={"Enables decryption based on any \"SKESK\" packets in the \"CIPHERTEXT\""}, paramLabel="PASSWORD")
    String[] withPassword;
    @CommandLine.Option(names={"--verify-out"}, description={"Produces signature verification status to the designated file"}, paramLabel="VERIFICATIONS")
    File verifyOut;
    @CommandLine.Option(names={"--verify-with"}, description={"Certificates whose signatures would be acceptable for signatures over this message"}, paramLabel="CERT")
    File[] certs;
    @CommandLine.Option(names={"--not-before"}, description={"ISO-8601 formatted UTC date (eg. '2020-11-23T16:35Z)\nReject signatures with a creation date not in range.\nDefaults to beginning of time (\"-\")."}, paramLabel="DATE")
    String notBefore = "-";
    @CommandLine.Option(names={"--not-after"}, description={"ISO-8601 formatted UTC date (eg. '2020-11-23T16:35Z)\nReject signatures with a creation date not in range.\nDefaults to current system time (\"now\").\nAccepts special value \"-\" for end of time."}, paramLabel="DATE")
    String notAfter = "now";
    @CommandLine.Parameters(index="0..*", description={"Secret keys to attempt decryption with"}, paramLabel="KEY")
    File[] keys;

    @Override
    public void run() {
        PGPSecretKeyRingCollection secretKeys;
        if (this.verifyOut == null ^ this.certs == null) {
            Print.err_ln("To enable signature verification, both --verify-out and at least one --verify-with argument must be supplied.");
            System.exit(23);
        }
        if (this.sessionKeyOut != null || this.withSessionKey != null) {
            Print.err_ln("session key in and out are not yet supported.");
            System.exit(1);
        }
        try {
            List<PGPSecretKeyRing> secretKeyRings = SopKeyUtil.loadKeysFromFiles(this.keys);
            secretKeys = new PGPSecretKeyRingCollection(secretKeyRings);
        }
        catch (IOException | PGPException e) {
            Print.err_ln(e.getMessage());
            System.exit(1);
            return;
        }
        PGPainless.decryptAndOrVerify().onInputStream(System.in).decryptWith(secretKeys);
    }
}

