/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;

public class ArmorUtils {
    public static String toAsciiArmoredString(PGPSecretKeyRing secretKeys) throws IOException {
        return ArmorUtils.toAsciiArmoredString(secretKeys.getEncoded());
    }

    public static String toAsciiArmoredString(PGPPublicKeyRing publicKeys) throws IOException {
        return ArmorUtils.toAsciiArmoredString(publicKeys.getEncoded());
    }

    public static String toAsciiArmoredString(byte[] bytes) throws IOException {
        return ArmorUtils.toAsciiArmoredString(new ByteArrayInputStream(bytes));
    }

    public static String toAsciiArmoredString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArmoredOutputStream armor = new ArmoredOutputStream(out);
        Streams.pipeAll(inputStream, armor);
        armor.close();
        return out.toString();
    }
}

