/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.Date;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.pgpainless.algorithm.SignatureSubpacket;

public class SignatureSubpacketGeneratorUtil {
    public static void removeAllPacketsOfType(SignatureSubpacket subpacketType, PGPSignatureSubpacketGenerator subpacketGenerator) {
        SignatureSubpacketGeneratorUtil.removeAllPacketsOfType(subpacketType.getCode(), subpacketGenerator);
    }

    public static void removeAllPacketsOfType(int type, PGPSignatureSubpacketGenerator subpacketGenerator) {
        for (org.bouncycastle.bcpg.SignatureSubpacket subpacket : subpacketGenerator.getSubpackets(type)) {
            subpacketGenerator.removePacket(subpacket);
        }
    }

    public static void setSignatureCreationTimeInSubpacketGenerator(Date date, PGPSignatureSubpacketGenerator subpacketGenerator) {
        SignatureSubpacketGeneratorUtil.removeAllPacketsOfType(2, subpacketGenerator);
        subpacketGenerator.setSignatureCreationTime(false, date);
    }

    public static void setExpirationDateInSubpacketGenerator(Date expirationDate, @Nonnull Date creationDate, PGPSignatureSubpacketGenerator subpacketGenerator) {
        SignatureSubpacketGeneratorUtil.removeAllPacketsOfType(9, subpacketGenerator);
        long secondsToExpire = SignatureSubpacketGeneratorUtil.getKeyLifetimeInSeconds(expirationDate, creationDate);
        subpacketGenerator.setKeyExpirationTime(true, secondsToExpire);
    }

    private static long getKeyLifetimeInSeconds(Date expirationDate, @Nonnull Date creationTime) {
        long secondsToExpire = 0L;
        if (expirationDate != null) {
            if (creationTime.after(expirationDate)) {
                throw new IllegalArgumentException("Key MUST NOT expire before being created. (creation: " + creationTime + ", expiration: " + expirationDate + ")");
            }
            secondsToExpire = (expirationDate.getTime() - creationTime.getTime()) / 1000L;
        }
        return secondsToExpire;
    }
}

