/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.Policy;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.DecryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditor;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.parsing.KeyRingReader;
import org.pgpainless.symmetric_encryption.SymmetricEncryptorDecryptor;
import org.pgpainless.util.Passphrase;

public class PGPainless {
    public static KeyRingBuilder generateKeyRing() {
        return new KeyRingBuilder();
    }

    public static KeyRingReader readKeyRing() {
        return new KeyRingReader();
    }

    @Deprecated
    public static EncryptionBuilder createEncryptor() {
        return PGPainless.encryptAndOrSign();
    }

    public static EncryptionBuilder encryptAndOrSign() {
        return new EncryptionBuilder();
    }

    public static EncryptionBuilder encryptAndOrSign(EncryptionStream.Purpose purpose) {
        return new EncryptionBuilder(purpose);
    }

    @Deprecated
    public static DecryptionBuilder createDecryptor() {
        return PGPainless.decryptAndOrVerify();
    }

    public static DecryptionBuilder decryptAndOrVerify() {
        return new DecryptionBuilder();
    }

    public static SecretKeyRingEditorInterface modifyKeyRing(PGPSecretKeyRing secretKeys) {
        return new SecretKeyRingEditor(secretKeys);
    }

    public static KeyRingInfo inspectKeyRing(PGPKeyRing keyRing) {
        return new KeyRingInfo(keyRing);
    }

    @Deprecated
    public static byte[] encryptWithPassword(@Nonnull byte[] data, @Nonnull Passphrase password, @Nonnull SymmetricKeyAlgorithm algorithm) throws IOException, PGPException {
        return SymmetricEncryptorDecryptor.symmetricallyEncrypt(data, password, algorithm, CompressionAlgorithm.UNCOMPRESSED);
    }

    @Deprecated
    public static byte[] decryptWithPassword(@Nonnull byte[] data, @Nonnull Passphrase password) throws IOException, PGPException {
        return SymmetricEncryptorDecryptor.symmetricallyDecrypt(data, password);
    }

    public static Policy getPolicy() {
        return Policy.getInstance();
    }
}

