/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum SymmetricKeyAlgorithm {
    NULL(0),
    IDEA(1),
    TRIPLE_DES(2),
    CAST5(3),
    BLOWFISH(4),
    SAFER(5),
    DES(6),
    AES_128(7),
    AES_192(8),
    AES_256(9),
    TWOFISH(10),
    CAMELLIA_128(11),
    CAMELLIA_192(12),
    CAMELLIA_256(13);

    private static final Map<Integer, SymmetricKeyAlgorithm> MAP;
    private final int algorithmId;

    public static SymmetricKeyAlgorithm fromId(int id) {
        return MAP.get(id);
    }

    private SymmetricKeyAlgorithm(int algorithmId) {
        this.algorithmId = algorithmId;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    static {
        MAP = new ConcurrentHashMap<Integer, SymmetricKeyAlgorithm>();
        for (SymmetricKeyAlgorithm s : SymmetricKeyAlgorithm.values()) {
            MAP.put(s.algorithmId, s);
        }
    }
}

