/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.OpenPgpKeyAttributeUtil;

public class SignatureUtils {
    public static PGPSignatureGenerator getSignatureGeneratorFor(PGPSecretKey singingKey) {
        return SignatureUtils.getSignatureGeneratorFor(singingKey.getPublicKey());
    }

    public static PGPSignatureGenerator getSignatureGeneratorFor(PGPPublicKey signingPubKey) {
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(SignatureUtils.getPgpContentSignerBuilderForKey(signingPubKey));
        return signatureGenerator;
    }

    private static BcPGPContentSignerBuilder getPgpContentSignerBuilderForKey(PGPPublicKey publicKey) {
        List<HashAlgorithm> preferredHashAlgorithms = OpenPgpKeyAttributeUtil.getPreferredHashAlgorithms(publicKey);
        if (preferredHashAlgorithms.isEmpty()) {
            preferredHashAlgorithms = OpenPgpKeyAttributeUtil.guessPreferredHashAlgorithms(publicKey);
        }
        HashAlgorithm hashAlgorithm = SignatureUtils.negotiateHashAlgorithm(preferredHashAlgorithms);
        return new BcPGPContentSignerBuilder(publicKey.getAlgorithm(), hashAlgorithm.getAlgorithmId());
    }

    private static HashAlgorithm negotiateHashAlgorithm(List<HashAlgorithm> preferredHashAlgorithms) {
        if (preferredHashAlgorithms.isEmpty()) {
            return PGPainless.getPolicy().getDefaultSignatureHashAlgorithm();
        }
        return preferredHashAlgorithms.get(0);
    }

    public static PGPSignature getLatestValidSignature(PGPPublicKey publicKey, List<PGPSignature> signatures, PGPKeyRing keyRing) throws PGPException {
        ArrayList<PGPSignature> valid = new ArrayList<PGPSignature>();
        for (PGPSignature signature : signatures) {
            long issuerID = signature.getKeyID();
            PGPPublicKey issuer = KeyRingUtils.getPublicKeyFrom(keyRing, issuerID);
            if (issuer == null || !SignatureUtils.isSignatureValid(signature, issuer, publicKey) || SignatureUtils.isSignatureExpired(signature)) continue;
            valid.add(signature);
        }
        SignatureUtils.sortByCreationTimeAscending(valid);
        return valid.isEmpty() ? null : (PGPSignature)valid.get(valid.size() - 1);
    }

    public static boolean isSignatureValid(PGPSignature signature, PGPPublicKey issuer, PGPPublicKey target) throws PGPException {
        SignatureType signatureType = SignatureType.valueOf(signature.getSignatureType());
        switch (signatureType) {
            case BINARY_DOCUMENT: 
            case CANONICAL_TEXT_DOCUMENT: 
            case STANDALONE: 
            case TIMESTAMP: 
            case THIRD_PARTY_CONFIRMATION: {
                throw new IllegalArgumentException("Signature is not a key signature.");
            }
            case GENERIC_CERTIFICATION: 
            case NO_CERTIFICATION: 
            case CASUAL_CERTIFICATION: 
            case POSITIVE_CERTIFICATION: 
            case DIRECT_KEY: 
            case KEY_REVOCATION: 
            case CERTIFICATION_REVOCATION: {
                return SignatureUtils.isSelfSignatureValid(signature, issuer);
            }
            case SUBKEY_BINDING: 
            case PRIMARYKEY_BINDING: 
            case SUBKEY_REVOCATION: {
                return SignatureUtils.isKeyOnKeySignatureValid(signature, issuer, target);
            }
        }
        return false;
    }

    public static boolean isKeyOnKeySignatureValid(PGPSignature signature, PGPPublicKey issuer, PGPPublicKey target) throws PGPException {
        signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), issuer);
        return signature.verifyCertification(issuer, target);
    }

    public static boolean isSelfSignatureValid(PGPSignature signature, PGPPublicKey publicKey) throws PGPException {
        Iterator<String> it = publicKey.getUserIDs();
        while (it.hasNext()) {
            String userId = it.next();
            boolean valid = SignatureUtils.isSelfSignatureOnUserIdValid(signature, userId, publicKey);
            if (!valid) continue;
            return true;
        }
        return false;
    }

    public static boolean isSelfSignatureOnUserIdValid(PGPSignature signature, String userId, PGPPublicKey publicKey) throws PGPException {
        signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), publicKey);
        return signature.verifyCertification(userId, publicKey);
    }

    public static boolean isSignatureExpired(PGPSignature signature) {
        long expiration = signature.getHashedSubPackets().getSignatureExpirationTime();
        if (expiration == 0L) {
            return false;
        }
        Date now = new Date();
        Date creation = signature.getCreationTime();
        return now.after(new Date(creation.getTime() + 1000L * expiration));
    }

    public static void sortByCreationTimeAscending(List<PGPSignature> signatures) {
        Collections.sort(signatures, new Comparator<PGPSignature>(){

            @Override
            public int compare(PGPSignature s1, PGPSignature s2) {
                return s1.getCreationTime().compareTo(s2.getCreationTime());
            }
        });
    }

    public static List<PGPSignature> getBindingSignatures(PGPPublicKey subKey, long primaryKeyId) {
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        List<PGPSignature> bindingSigs = SignatureUtils.getSignaturesOfTypes(subKey, SignatureType.SUBKEY_BINDING);
        for (PGPSignature signature : bindingSigs) {
            if (signature.getKeyID() != primaryKeyId) continue;
            signatures.add(signature);
        }
        return signatures;
    }

    public static List<PGPSignature> getSignaturesOfTypes(PGPPublicKey publicKey, SignatureType ... types) {
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        for (SignatureType type : types) {
            Iterator it = publicKey.getSignaturesOfType(type.getCode());
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof PGPSignature)) continue;
                signatures.add((PGPSignature)o);
            }
        }
        SignatureUtils.sortByCreationTimeAscending(signatures);
        return signatures;
    }

    public static List<PGPSignature> getSignaturesForUserId(PGPPublicKey publicKey, String userId) {
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        Iterator<PGPSignature> it = publicKey.getSignaturesForID(userId);
        while (it != null && it.hasNext()) {
            PGPSignature o = it.next();
            if (!(o instanceof PGPSignature)) continue;
            signatures.add(o);
        }
        SignatureUtils.sortByCreationTimeAscending(signatures);
        return signatures;
    }

    public static PGPSignature getLatestSelfSignatureForUserId(PGPPublicKey publicKey, String userId) throws PGPException {
        ArrayList<PGPSignature> valid = new ArrayList<PGPSignature>();
        List<PGPSignature> signatures = SignatureUtils.getSignaturesForUserId(publicKey, userId);
        for (PGPSignature signature : signatures) {
            if (!SignatureUtils.isSelfSignatureOnUserIdValid(signature, userId, publicKey)) continue;
            valid.add(signature);
        }
        return valid.isEmpty() ? null : (PGPSignature)valid.get(valid.size() - 1);
    }

    public static boolean isUserIdValid(PGPPublicKey publicKey, String userId) throws PGPException {
        PGPSignature latestSelfSig = SignatureUtils.getLatestSelfSignatureForUserId(publicKey, userId);
        if (latestSelfSig == null) {
            return false;
        }
        return latestSelfSig.getSignatureType() != SignatureType.CERTIFICATION_REVOCATION.getCode();
    }
}

