/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Scanner;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionBuilderInterface;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PassphraseMapKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.Print;
import org.pgpainless.util.Passphrase;
import picocli.CommandLine;

@CommandLine.Command(name="encrypt", description={"Encrypt a message from standard input"})
public class Encrypt
implements Runnable {
    @CommandLine.Option(names={"--no-armor"}, description={"ASCII armor the output"}, negatable=true)
    boolean armor = true;
    @CommandLine.Option(names={"--as"}, description={"Type of the input data. Defaults to 'binary'"}, paramLabel="{binary|text|mime}")
    Type type;
    @CommandLine.Option(names={"--with-password"}, description={"Encrypt the message with a password"}, paramLabel="PASSWORD")
    String[] withPassword = new String[0];
    @CommandLine.Option(names={"--sign-with"}, description={"Sign the output with a private key"}, paramLabel="KEY")
    File[] signWith = new File[0];
    @CommandLine.Parameters(description={"Certificates the message gets encrypted to"}, index="0..*", paramLabel="CERTS")
    File[] certs = new File[0];

    @Override
    public void run() {
        EncryptionBuilderInterface.Armor builder_armor;
        if (this.certs.length == 0 && this.withPassword.length == 0) {
            Print.err_ln("Please either provide --with-password or at least one CERT");
            System.exit(19);
        }
        PGPPublicKeyRing[] publicKeys = new PGPPublicKeyRing[this.certs.length];
        for (int i = 0; i < this.certs.length; ++i) {
            try (FileInputStream fileIn = new FileInputStream(this.certs[i]);){
                PGPPublicKeyRing publicKey;
                publicKeys[i] = publicKey = PGPainless.readKeyRing().publicKeyRing(fileIn);
                continue;
            }
            catch (IOException e) {
                Print.err_ln("Cannot read certificate " + this.certs[i].getName());
                Print.err_ln(e.getMessage());
                System.exit(1);
            }
        }
        PGPSecretKeyRing[] secretKeys = new PGPSecretKeyRing[this.signWith.length];
        for (int i = 0; i < this.signWith.length; ++i) {
            try (FileInputStream fileIn = new FileInputStream(this.signWith[i]);){
                PGPSecretKeyRing secretKey;
                secretKeys[i] = secretKey = PGPainless.readKeyRing().secretKeyRing(fileIn);
                continue;
            }
            catch (IOException | PGPException e) {
                Print.err_ln("Cannot read secret key from file " + this.signWith[i].getName());
                Print.err_ln(e.getMessage());
                System.exit(1);
            }
        }
        Passphrase[] passphraseArray = new Passphrase[this.withPassword.length];
        for (int i = 0; i < this.withPassword.length; ++i) {
            String password = this.withPassword[i];
            passphraseArray[i] = Passphrase.fromPassword(password);
        }
        HashMap<Long, Passphrase> passphraseMap = new HashMap<Long, Passphrase>();
        Scanner scanner = null;
        for (PGPSecretKeyRing ring : secretKeys) {
            for (PGPSecretKey key : ring) {
                PGPSignature signature = (PGPSignature)key.getPublicKey().getSignatures().next();
                int flags = signature.getHashedSubPackets().getKeyFlags();
                if (!key.isSigningKey() || !KeyFlag.hasKeyFlag(flags, KeyFlag.SIGN_DATA)) continue;
                if (key.getKeyEncryptionAlgorithm() == SymmetricKeyAlgorithm.NULL.getAlgorithmId()) {
                    passphraseMap.put(key.getKeyID(), Passphrase.emptyPassphrase());
                    continue;
                }
                Print.print_ln("Please provide the passphrase for key " + new OpenPgpV4Fingerprint(key));
                if (scanner == null) {
                    scanner = new Scanner(System.in);
                }
                String password = scanner.nextLine();
                Passphrase passphrase = Passphrase.fromPassword(password.trim());
                passphraseMap.put(key.getKeyID(), passphrase);
            }
        }
        EncryptionBuilderInterface.DetachedSign builder = PGPainless.encryptAndOrSign().onOutputStream(System.out).toRecipients(publicKeys).and().forPassphrases(passphraseArray).usingSecureAlgorithms();
        if (this.signWith.length != 0) {
            EncryptionBuilderInterface.DocumentType documentType = builder.signWith((SecretKeyRingProtector)new PassphraseMapKeyRingProtector(passphraseMap, KeyRingProtectionSettings.secureDefaultSettings(), null), secretKeys);
            builder_armor = this.type == Type.text || this.type == Type.mime ? documentType.signCanonicalText() : documentType.signBinaryDocument();
        } else {
            builder_armor = builder.doNotSign();
        }
        try {
            EncryptionStream encryptionStream = !this.armor ? builder_armor.noArmor() : builder_armor.asciiArmor();
            Streams.pipeAll(System.in, encryptionStream);
            encryptionStream.close();
        }
        catch (IOException | PGPException e) {
            Print.err_ln("An error happened.");
            Print.err_ln(e.getMessage());
            System.exit(1);
        }
    }

    public static enum Type {
        binary,
        text,
        mime;

    }
}

