/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop.commands;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.PGPainless;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.sop.Print;
import picocli.CommandLine;

@CommandLine.Command(name="extract-cert", description={"Extract a public key certificate from a secret key from standard input"})
public class ExtractCert
implements Runnable {
    @CommandLine.Option(names={"--no-armor"}, description={"ASCII armor the output"}, negatable=true)
    boolean armor = true;

    @Override
    public void run() {
        try {
            PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(System.in);
            PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom(secretKeys);
            Print.print_ln(Print.toString(publicKeys.getEncoded(), this.armor));
        }
        catch (IOException | PGPException e) {
            Print.err_ln("Error extracting certificate from keys;");
            Print.err_ln(e.getMessage());
            System.exit(1);
        }
    }
}

