/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.symmetric_encryption;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.operator.bc.BcPBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.provider.ProviderFactory;
import org.pgpainless.util.Passphrase;

public class SymmetricEncryptorDecryptor {
    public static byte[] symmetricallyEncrypt(@Nonnull byte[] data, @Nonnull Passphrase password, @Nonnull SymmetricKeyAlgorithm encryptionAlgorithm, @Nonnull CompressionAlgorithm compressionAlgorithm) throws IOException, PGPException {
        byte[] compressedData = SymmetricEncryptorDecryptor.compress(data, compressionAlgorithm.getAlgorithmId());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(encryptionAlgorithm.getAlgorithmId()).setWithIntegrityPacket(true).setSecureRandom(new SecureRandom()).setProvider(ProviderFactory.getProvider()));
        encGen.addMethod(new JcePBEKeyEncryptionMethodGenerator(password.getChars()).setProvider(ProviderFactory.getProvider()));
        OutputStream encOut = encGen.open((OutputStream)bOut, compressedData.length);
        encOut.write(compressedData);
        encOut.close();
        return bOut.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] symmetricallyDecrypt(@Nonnull byte[] data, @Nonnull Passphrase password) throws IOException, PGPException {
        PGPPBEEncryptedData pbe;
        ByteArrayOutputStream outputStream = null;
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(data));
        try (InputStream in = PGPUtil.getDecoderStream(bis);){
            BcPGPObjectFactory pgpF = new BcPGPObjectFactory(in);
            Object o = pgpF.nextObject();
            PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
            pbe = (PGPPBEEncryptedData)enc.get(0);
            InputStream clear = pbe.getDataStream(new BcPBEDataDecryptorFactory(password.getChars(), new BcPGPDigestCalculatorProvider()));
            BcPGPObjectFactory pgpFact = new BcPGPObjectFactory(clear);
            o = pgpFact.nextObject();
            if (o instanceof PGPCompressedData) {
                PGPCompressedData cData = (PGPCompressedData)o;
                pgpFact = new BcPGPObjectFactory(cData.getDataStream());
                o = pgpFact.nextObject();
            }
            PGPLiteralData ld = (PGPLiteralData)o;
            InputStream unc = ld.getInputStream();
            try {
                outputStream = new ByteArrayOutputStream();
                Streams.pipeAll(unc, outputStream);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        if (pbe.isIntegrityProtected()) {
            if (!pbe.verify()) {
                throw new PGPException("Integrity check failed.");
            }
        } else {
            throw new PGPException("Symmetrically encrypted data is not integrity protected.");
        }
        return outputStream.toByteArray();
    }

    private static byte[] compress(@Nonnull byte[] clearData, int algorithm) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(algorithm);
        OutputStream cos = comData.open(bOut);
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(cos, 'b', "_CONSOLE", clearData.length, new Date());
        pOut.write(clearData);
        pOut.close();
        comData.close();
        return bOut.toByteArray();
    }
}

