/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.key.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.util.selection.key.PublicKeySelectionStrategy;

public class KeyBelongsToKeyRing {
    private static final Logger LOGGER = Logger.getLogger(KeyBelongsToKeyRing.class.getName());

    public static class PubkeySelectionStrategy
    extends PublicKeySelectionStrategy {
        private final PGPPublicKey masterKey;

        public PubkeySelectionStrategy(PGPPublicKey masterKey) {
            this.masterKey = masterKey;
        }

        @Override
        public boolean accept(@Nonnull PGPPublicKey key) {
            if (Arrays.equals(this.masterKey.getFingerprint(), key.getFingerprint())) {
                return true;
            }
            Iterator<PGPSignature> signatures = key.getSignaturesForKeyID(this.masterKey.getKeyID());
            while (signatures.hasNext()) {
                PGPSignature signature = signatures.next();
                if (signature.getSignatureType() != 24) continue;
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), this.masterKey);
                    return signature.verifyCertification(this.masterKey, key);
                }
                catch (PGPException e) {
                    LOGGER.log(Level.WARNING, "Could not verify subkey signature of key " + Long.toHexString(this.masterKey.getKeyID()) + " on key " + Long.toHexString(key.getKeyID()));
                    return false;
                }
            }
            return false;
        }
    }
}

