/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.pgpainless.decryption_verification.DetachedSignature;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.util.IntegrityProtectedInputStream;

public class DecryptionStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger(DecryptionStream.class.getName());
    private final InputStream inputStream;
    private final OpenPgpMetadata.Builder resultBuilder;
    private boolean isClosed = false;
    private List<IntegrityProtectedInputStream> integrityProtectedInputStreamList;

    DecryptionStream(@Nonnull InputStream wrapped, @Nonnull OpenPgpMetadata.Builder resultBuilder, List<IntegrityProtectedInputStream> integrityProtectedInputStreamList) {
        this.inputStream = wrapped;
        this.resultBuilder = resultBuilder;
        this.integrityProtectedInputStreamList = integrityProtectedInputStreamList;
    }

    @Override
    public int read() throws IOException {
        int r = this.inputStream.read();
        this.maybeUpdateDetachedSignatures(r);
        return r;
    }

    private void maybeUpdateDetachedSignatures(int rByte) {
        for (DetachedSignature s : this.resultBuilder.getDetachedSignatures()) {
            if (rByte == -1) continue;
            s.getSignature().update((byte)rByte);
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.maybeVerifyDetachedSignatures();
        for (IntegrityProtectedInputStream s : this.integrityProtectedInputStreamList) {
            s.close();
        }
        this.isClosed = true;
    }

    void maybeVerifyDetachedSignatures() {
        for (DetachedSignature s : this.resultBuilder.getDetachedSignatures()) {
            try {
                s.setVerified(s.getSignature().verify());
            }
            catch (PGPException e) {
                LOGGER.log(Level.WARNING, "Could not verify signature of key " + s.getFingerprint(), e);
            }
        }
    }

    public OpenPgpMetadata getResult() {
        if (!this.isClosed) {
            throw new IllegalStateException("DecryptionStream MUST be closed before the result can be accessed.");
        }
        return this.resultBuilder.build();
    }
}

