/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionBuilderInterface;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.exception.SecretKeyNotFoundException;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.MultiMap;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.selection.key.PublicKeySelectionStrategy;
import org.pgpainless.util.selection.key.SecretKeySelectionStrategy;
import org.pgpainless.util.selection.key.impl.And;
import org.pgpainless.util.selection.key.impl.EncryptionKeySelectionStrategy;
import org.pgpainless.util.selection.key.impl.NoRevocation;
import org.pgpainless.util.selection.key.impl.SignatureKeySelectionStrategy;
import org.pgpainless.util.selection.keyring.PublicKeyRingSelectionStrategy;
import org.pgpainless.util.selection.keyring.SecretKeyRingSelectionStrategy;

public class EncryptionBuilder
implements EncryptionBuilderInterface {
    private final EncryptionStream.Purpose purpose;
    private OutputStream outputStream;
    private final Set<PGPPublicKey> encryptionKeys = new HashSet<PGPPublicKey>();
    private final Set<Passphrase> encryptionPassphrases = new HashSet<Passphrase>();
    private boolean detachedSignature = false;
    private SignatureType signatureType = SignatureType.BINARY_DOCUMENT;
    private final Set<PGPSecretKey> signingKeys = new HashSet<PGPSecretKey>();
    private SecretKeyRingProtector signingKeysDecryptor;
    private SymmetricKeyAlgorithm symmetricKeyAlgorithm = SymmetricKeyAlgorithm.AES_128;
    private HashAlgorithm hashAlgorithm = HashAlgorithm.SHA256;
    private CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.UNCOMPRESSED;
    private boolean asciiArmor = false;
    private String fileName;
    private boolean forYourEyesOnly;

    public EncryptionBuilder() {
        this.purpose = EncryptionStream.Purpose.COMMUNICATIONS;
    }

    public EncryptionBuilder(@Nonnull EncryptionStream.Purpose purpose) {
        this.purpose = purpose;
    }

    @Override
    public EncryptionBuilderInterface.ToRecipients onOutputStream(@Nonnull OutputStream outputStream, String fileName, boolean forYourEyesOnly) {
        this.outputStream = outputStream;
        this.fileName = fileName == null ? "" : fileName;
        this.forYourEyesOnly = forYourEyesOnly;
        return new ToRecipientsImpl();
    }

    PublicKeySelectionStrategy encryptionKeySelector() {
        KeyFlag[] flags = EncryptionBuilder.mapPurposeToKeyFlags(this.purpose);
        return new And.PubKeySelectionStrategy(new NoRevocation.PubKeySelectionStrategy(), new EncryptionKeySelectionStrategy(flags));
    }

    SecretKeySelectionStrategy signingKeySelector() {
        return new And.SecKeySelectionStrategy(new NoRevocation.SecKeySelectionStrategy(), new SignatureKeySelectionStrategy());
    }

    private static KeyFlag[] mapPurposeToKeyFlags(EncryptionStream.Purpose purpose) {
        KeyFlag[] flags;
        switch (purpose) {
            case COMMUNICATIONS: {
                flags = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS};
                break;
            }
            case STORAGE: {
                flags = new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE};
                break;
            }
            case STORAGE_AND_COMMUNICATIONS: {
                flags = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
                break;
            }
            default: {
                throw new AssertionError((Object)"Illegal purpose enum value encountered.");
            }
        }
        return flags;
    }

    class ArmorImpl
    implements EncryptionBuilderInterface.Armor {
        ArmorImpl() {
        }

        @Override
        public EncryptionStream asciiArmor() throws IOException, PGPException {
            EncryptionBuilder.this.asciiArmor = true;
            return this.build();
        }

        @Override
        public EncryptionStream noArmor() throws IOException, PGPException {
            EncryptionBuilder.this.asciiArmor = false;
            return this.build();
        }

        private EncryptionStream build() throws IOException, PGPException {
            ConcurrentHashMap<OpenPgpV4Fingerprint, PGPPrivateKey> privateKeys = new ConcurrentHashMap<OpenPgpV4Fingerprint, PGPPrivateKey>();
            for (PGPSecretKey secretKey : EncryptionBuilder.this.signingKeys) {
                PBESecretKeyDecryptor decryptor = EncryptionBuilder.this.signingKeysDecryptor.getDecryptor(secretKey.getKeyID());
                PGPPrivateKey privateKey = secretKey.extractPrivateKey(decryptor);
                privateKeys.put(new OpenPgpV4Fingerprint(secretKey), privateKey);
            }
            return new EncryptionStream(EncryptionBuilder.this.outputStream, EncryptionBuilder.this.encryptionKeys, EncryptionBuilder.this.encryptionPassphrases, EncryptionBuilder.this.detachedSignature, EncryptionBuilder.this.signatureType, privateKeys, EncryptionBuilder.this.symmetricKeyAlgorithm, EncryptionBuilder.this.hashAlgorithm, EncryptionBuilder.this.compressionAlgorithm, EncryptionBuilder.this.asciiArmor, EncryptionBuilder.this.fileName, EncryptionBuilder.this.forYourEyesOnly);
        }
    }

    class DocumentTypeImpl
    implements EncryptionBuilderInterface.DocumentType {
        DocumentTypeImpl() {
        }

        @Override
        public EncryptionBuilderInterface.Armor signBinaryDocument() {
            EncryptionBuilder.this.signatureType = SignatureType.BINARY_DOCUMENT;
            return new ArmorImpl();
        }

        @Override
        public EncryptionBuilderInterface.Armor signCanonicalText() {
            EncryptionBuilder.this.signatureType = SignatureType.CANONICAL_TEXT_DOCUMENT;
            return new ArmorImpl();
        }
    }

    class SignWithImpl
    implements EncryptionBuilderInterface.SignWith {
        SignWithImpl() {
        }

        @Override
        public EncryptionBuilderInterface.DocumentType signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKey ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            for (PGPSecretKey s : keys) {
                if (!EncryptionBuilder.this.signingKeySelector().accept(s)) {
                    throw new IllegalArgumentException("Key " + s.getKeyID() + " is not a valid signing key.");
                }
                EncryptionBuilder.this.signingKeys.add(s);
            }
            EncryptionBuilder.this.signingKeysDecryptor = decryptor;
            return new DocumentTypeImpl();
        }

        @Override
        public EncryptionBuilderInterface.DocumentType signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKeyRing ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            for (PGPSecretKeyRing key : keys) {
                Iterator<PGPSecretKey> i = key.getSecretKeys();
                while (i.hasNext()) {
                    PGPSecretKey s = i.next();
                    if (!EncryptionBuilder.this.signingKeySelector().accept(s)) continue;
                    EncryptionBuilder.this.signingKeys.add(s);
                }
            }
            EncryptionBuilder.this.signingKeysDecryptor = decryptor;
            return new DocumentTypeImpl();
        }

        @Override
        public <O> EncryptionBuilderInterface.DocumentType signWith(@Nonnull SecretKeyRingSelectionStrategy<O> ringSelectionStrategy, @Nonnull SecretKeyRingProtector decryptor, @Nonnull MultiMap<O, PGPSecretKeyRingCollection> keys) {
            if (keys.isEmpty()) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            MultiMap<O, PGPSecretKeyRing> acceptedKeyRings = ringSelectionStrategy.selectKeyRingsFromCollections(keys);
            for (O identifier : acceptedKeyRings.keySet()) {
                Set<PGPSecretKeyRing> acceptedSet = acceptedKeyRings.get(identifier);
                for (PGPSecretKeyRing k : acceptedSet) {
                    Iterator<PGPSecretKey> i = k.getSecretKeys();
                    while (i.hasNext()) {
                        PGPSecretKey s = i.next();
                        if (!EncryptionBuilder.this.signingKeySelector().accept(s)) continue;
                        EncryptionBuilder.this.signingKeys.add(s);
                    }
                }
            }
            return new DocumentTypeImpl();
        }
    }

    class DetachedSignImpl
    implements EncryptionBuilderInterface.DetachedSign {
        DetachedSignImpl() {
        }

        @Override
        public EncryptionBuilderInterface.SignWith createDetachedSignature() {
            EncryptionBuilder.this.detachedSignature = true;
            return new SignWithImpl();
        }

        @Override
        public EncryptionBuilderInterface.Armor doNotSign() {
            return new ArmorImpl();
        }

        @Override
        public EncryptionBuilderInterface.DocumentType signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKey ... keys) {
            return new SignWithImpl().signWith(decryptor, keys);
        }

        @Override
        public EncryptionBuilderInterface.DocumentType signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKeyRing ... keyRings) {
            return new SignWithImpl().signWith(decryptor, keyRings);
        }

        @Override
        public <O> EncryptionBuilderInterface.DocumentType signWith(@Nonnull SecretKeyRingSelectionStrategy<O> selectionStrategy, @Nonnull SecretKeyRingProtector decryptor, @Nonnull MultiMap<O, PGPSecretKeyRingCollection> keys) throws SecretKeyNotFoundException {
            return new SignWithImpl().signWith(selectionStrategy, decryptor, keys);
        }
    }

    class WithAlgorithmsImpl
    implements EncryptionBuilderInterface.WithAlgorithms {
        WithAlgorithmsImpl() {
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms andToSelf(PGPPublicKey ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            for (PGPPublicKey k : keys) {
                if (!EncryptionBuilder.this.encryptionKeySelector().accept(k)) {
                    throw new IllegalArgumentException("Key " + k.getKeyID() + " is not a valid encryption key.");
                }
                EncryptionBuilder.this.encryptionKeys.add(k);
            }
            return this;
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms andToSelf(PGPPublicKeyRing ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            for (PGPPublicKeyRing ring : keys) {
                Iterator<PGPPublicKey> i = ring.getPublicKeys();
                while (i.hasNext()) {
                    PGPPublicKey key = i.next();
                    if (!EncryptionBuilder.this.encryptionKeySelector().accept(key)) continue;
                    EncryptionBuilder.this.encryptionKeys.add(key);
                }
            }
            return this;
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms andToSelf(@Nonnull PGPPublicKeyRingCollection keys) {
            for (PGPPublicKeyRing ring : keys) {
                Iterator<PGPPublicKey> i = ring.getPublicKeys();
                while (i.hasNext()) {
                    PGPPublicKey key = i.next();
                    if (!EncryptionBuilder.this.encryptionKeySelector().accept(key)) continue;
                    EncryptionBuilder.this.encryptionKeys.add(key);
                }
            }
            return this;
        }

        @Override
        public <O> EncryptionBuilderInterface.WithAlgorithms andToSelf(@Nonnull PublicKeyRingSelectionStrategy<O> ringSelectionStrategy, @Nonnull MultiMap<O, PGPPublicKeyRingCollection> keys) {
            if (keys.isEmpty()) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            MultiMap<O, PGPPublicKeyRing> acceptedKeyRings = ringSelectionStrategy.selectKeyRingsFromCollections(keys);
            for (O identifier : acceptedKeyRings.keySet()) {
                Set<PGPPublicKeyRing> acceptedSet = acceptedKeyRings.get(identifier);
                for (PGPPublicKeyRing k : acceptedSet) {
                    Iterator<PGPPublicKey> i = k.getPublicKeys();
                    while (i.hasNext()) {
                        PGPPublicKey key = i.next();
                        if (!EncryptionBuilder.this.encryptionKeySelector().accept(key)) continue;
                        EncryptionBuilder.this.encryptionKeys.add(key);
                    }
                }
            }
            return this;
        }

        @Override
        public EncryptionBuilderInterface.DetachedSign usingAlgorithms(@Nonnull SymmetricKeyAlgorithm symmetricKeyAlgorithm, @Nonnull HashAlgorithm hashAlgorithm, @Nonnull CompressionAlgorithm compressionAlgorithm) {
            EncryptionBuilder.this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
            EncryptionBuilder.this.hashAlgorithm = hashAlgorithm;
            EncryptionBuilder.this.compressionAlgorithm = compressionAlgorithm;
            return new DetachedSignImpl();
        }

        @Override
        public EncryptionBuilderInterface.DetachedSign usingSecureAlgorithms() {
            EncryptionBuilder.this.symmetricKeyAlgorithm = SymmetricKeyAlgorithm.AES_256;
            EncryptionBuilder.this.hashAlgorithm = HashAlgorithm.SHA512;
            EncryptionBuilder.this.compressionAlgorithm = CompressionAlgorithm.UNCOMPRESSED;
            return new DetachedSignImpl();
        }

        @Override
        public EncryptionBuilderInterface.ToRecipients and() {
            return new ToRecipientsImpl();
        }
    }

    class ToRecipientsImpl
    implements EncryptionBuilderInterface.ToRecipients {
        ToRecipientsImpl() {
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms toRecipients(PGPPublicKey ... keys) {
            if (keys.length != 0) {
                ArrayList<PGPPublicKey> encryptionKeys = new ArrayList<PGPPublicKey>();
                for (PGPPublicKey k : keys) {
                    if (!EncryptionBuilder.this.encryptionKeySelector().accept(k)) {
                        throw new IllegalArgumentException("Key " + k.getKeyID() + " is not a valid encryption key.");
                    }
                    encryptionKeys.add(k);
                }
                if (encryptionKeys.isEmpty()) {
                    throw new IllegalArgumentException("No valid encryption keys found!");
                }
                EncryptionBuilder.this.encryptionKeys.addAll(encryptionKeys);
            }
            return new WithAlgorithmsImpl();
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms toRecipients(PGPPublicKeyRing ... keys) {
            if (keys.length != 0) {
                ArrayList<PGPPublicKey> encryptionKeys = new ArrayList<PGPPublicKey>();
                for (PGPPublicKeyRing ring : keys) {
                    for (PGPPublicKey k : ring) {
                        if (!EncryptionBuilder.this.encryptionKeySelector().accept(k)) continue;
                        encryptionKeys.add(k);
                    }
                }
                if (encryptionKeys.isEmpty()) {
                    throw new IllegalArgumentException("No valid encryption keys found!");
                }
                EncryptionBuilder.this.encryptionKeys.addAll(encryptionKeys);
            }
            return new WithAlgorithmsImpl();
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms toRecipients(PGPPublicKeyRingCollection ... keys) {
            if (keys.length != 0) {
                ArrayList<PGPPublicKey> encryptionKeys = new ArrayList<PGPPublicKey>();
                for (PGPPublicKeyRingCollection collection : keys) {
                    for (PGPPublicKeyRing ring : collection) {
                        for (PGPPublicKey k : ring) {
                            if (!EncryptionBuilder.this.encryptionKeySelector().accept(k)) continue;
                            encryptionKeys.add(k);
                        }
                    }
                }
                if (encryptionKeys.isEmpty()) {
                    throw new IllegalArgumentException("No valid encryption keys found!");
                }
                EncryptionBuilder.this.encryptionKeys.addAll(encryptionKeys);
            }
            return new WithAlgorithmsImpl();
        }

        @Override
        public <O> EncryptionBuilderInterface.WithAlgorithms toRecipients(@Nonnull PublicKeyRingSelectionStrategy<O> ringSelectionStrategy, @Nonnull MultiMap<O, PGPPublicKeyRingCollection> keys) {
            if (keys.isEmpty()) {
                throw new IllegalArgumentException("Recipient map MUST NOT be empty.");
            }
            MultiMap<O, PGPPublicKeyRing> acceptedKeyRings = ringSelectionStrategy.selectKeyRingsFromCollections(keys);
            for (O identifier : acceptedKeyRings.keySet()) {
                Set<PGPPublicKeyRing> acceptedSet = acceptedKeyRings.get(identifier);
                for (PGPPublicKeyRing ring : acceptedSet) {
                    for (PGPPublicKey k : ring) {
                        if (!EncryptionBuilder.this.encryptionKeySelector().accept(k)) continue;
                        EncryptionBuilder.this.encryptionKeys.add(k);
                    }
                }
            }
            if (EncryptionBuilder.this.encryptionKeys.isEmpty()) {
                throw new IllegalArgumentException("No valid encryption keys found!");
            }
            return new WithAlgorithmsImpl();
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms forPassphrases(Passphrase ... passphrases) {
            ArrayList<Passphrase> passphraseList = new ArrayList<Passphrase>();
            for (Passphrase passphrase : passphrases) {
                if (passphrase.isEmpty()) {
                    throw new IllegalArgumentException("Passphrase must not be empty.");
                }
                passphraseList.add(passphrase);
            }
            EncryptionBuilder.this.encryptionPassphrases.addAll(passphraseList);
            return new WithAlgorithmsImpl();
        }

        @Override
        public EncryptionBuilderInterface.DetachedSign doNotEncrypt() {
            return new DetachedSignImpl();
        }
    }
}

