/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.collection;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

public class PGPKeyRingCollection {
    private PGPSecretKeyRingCollection pgpSecretKeyRingCollection;
    private PGPPublicKeyRingCollection pgpPublicKeyRingCollection;

    public PGPKeyRingCollection(@Nonnull byte[] encoding, @Nonnull KeyFingerPrintCalculator fingerPrintCalculator, boolean isSilent) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator, isSilent);
    }

    public PGPKeyRingCollection(@Nonnull InputStream in, @Nonnull KeyFingerPrintCalculator fingerPrintCalculator, boolean isSilent) throws IOException, PGPException {
        Object obj;
        PGPObjectFactory pgpFact = new PGPObjectFactory(in, fingerPrintCalculator);
        ArrayList<PGPSecretKeyRing> secretKeyRings = new ArrayList<PGPSecretKeyRing>();
        ArrayList<PGPPublicKeyRing> publicKeyRings = new ArrayList<PGPPublicKeyRing>();
        while ((obj = pgpFact.nextObject()) != null) {
            if (obj instanceof PGPSecretKeyRing) {
                secretKeyRings.add((PGPSecretKeyRing)obj);
                continue;
            }
            if (obj instanceof PGPPublicKeyRing) {
                publicKeyRings.add((PGPPublicKeyRing)obj);
                continue;
            }
            if (isSilent) continue;
            throw new PGPException(obj.getClass().getName() + " found where " + PGPSecretKeyRing.class.getSimpleName() + " or " + PGPPublicKeyRing.class.getSimpleName() + " expected");
        }
        this.pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(secretKeyRings);
        this.pgpPublicKeyRingCollection = new PGPPublicKeyRingCollection(publicKeyRings);
    }

    public PGPKeyRingCollection(Collection<PGPKeyRing> collection, boolean isSilent) throws IOException, PGPException {
        ArrayList<PGPSecretKeyRing> secretKeyRings = new ArrayList<PGPSecretKeyRing>();
        ArrayList<PGPPublicKeyRing> publicKeyRings = new ArrayList<PGPPublicKeyRing>();
        for (PGPKeyRing pgpKeyRing : collection) {
            if (pgpKeyRing instanceof PGPSecretKeyRing) {
                secretKeyRings.add((PGPSecretKeyRing)pgpKeyRing);
                continue;
            }
            if (pgpKeyRing instanceof PGPPublicKeyRing) {
                publicKeyRings.add((PGPPublicKeyRing)pgpKeyRing);
                continue;
            }
            if (isSilent) continue;
            throw new PGPException(pgpKeyRing.getClass().getName() + " found where " + PGPSecretKeyRing.class.getSimpleName() + " or " + PGPPublicKeyRing.class.getSimpleName() + " expected");
        }
        this.pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(secretKeyRings);
        this.pgpPublicKeyRingCollection = new PGPPublicKeyRingCollection(publicKeyRings);
    }

    public PGPSecretKeyRingCollection getPGPSecretKeyRingCollection() {
        return this.pgpSecretKeyRingCollection;
    }

    public PGPPublicKeyRingCollection getPgpPublicKeyRingCollection() {
        return this.pgpPublicKeyRingCollection;
    }

    public int size() {
        return this.pgpSecretKeyRingCollection.size() + this.pgpPublicKeyRingCollection.size();
    }
}

