/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.pgpainless.algorithm.PublicKeyAlgorithm;

public class KeyInfo {
    private final PGPSecretKey secretKey;
    private final PGPPublicKey publicKey;

    public KeyInfo(PGPSecretKey secretKey) {
        this.secretKey = secretKey;
        this.publicKey = secretKey.getPublicKey();
    }

    public KeyInfo(PGPPublicKey publicKey) {
        this.publicKey = publicKey;
        this.secretKey = null;
    }

    public static String getCurveName(PGPPublicKey publicKey) {
        ECPublicBCPGKey key;
        PublicKeyAlgorithm algorithm = PublicKeyAlgorithm.fromId(publicKey.getAlgorithm());
        switch (algorithm) {
            case ECDSA: {
                key = (ECDSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                break;
            }
            case ECDH: {
                key = (ECDHPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                break;
            }
            case EDDSA: {
                key = (EdDSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey();
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a EC public key (" + (Object)((Object)algorithm) + ")");
            }
        }
        return KeyInfo.getCurveName(key);
    }

    public static String getCurveName(ECPublicBCPGKey key) {
        return ECUtil.getCurveName(key.getCurveOID());
    }
}

