/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.SignatureUtils;
import org.pgpainless.util.CollectionUtils;

public class KeyRingInfo {
    private static final Pattern PATTERN_EMAIL = Pattern.compile("[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,6}");
    private final PGPKeyRing keys;

    public KeyRingInfo(PGPKeyRing keys) {
        this.keys = keys;
    }

    public PGPPublicKey getPublicKey() {
        return this.keys.getPublicKey();
    }

    public PGPPublicKey getPublicKey(OpenPgpV4Fingerprint fingerprint) {
        return this.getPublicKey(fingerprint.getKeyId());
    }

    public PGPPublicKey getPublicKey(long keyId) {
        return this.keys.getPublicKey(keyId);
    }

    public static PGPPublicKey getPublicKey(PGPKeyRing keyRing, long keyId) {
        return keyRing.getPublicKey(keyId);
    }

    public List<PGPPublicKey> getPublicKeys() {
        Iterator<PGPPublicKey> iterator = this.keys.getPublicKeys();
        List<PGPPublicKey> list = CollectionUtils.iteratorToList(iterator);
        return Collections.unmodifiableList(list);
    }

    public PGPSecretKey getSecretKey() {
        if (this.keys instanceof PGPSecretKeyRing) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)this.keys;
            return secretKeys.getSecretKey();
        }
        return null;
    }

    public PGPSecretKey getSecretKey(OpenPgpV4Fingerprint fingerprint) {
        return this.getSecretKey(fingerprint.getKeyId());
    }

    public PGPSecretKey getSecretKey(long keyId) {
        if (this.keys instanceof PGPSecretKeyRing) {
            return ((PGPSecretKeyRing)this.keys).getSecretKey(keyId);
        }
        return null;
    }

    public List<PGPSecretKey> getSecretKeys() {
        if (this.keys instanceof PGPSecretKeyRing) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)this.keys;
            Iterator<PGPSecretKey> iterator = secretKeys.getSecretKeys();
            return Collections.unmodifiableList(CollectionUtils.iteratorToList(iterator));
        }
        return Collections.emptyList();
    }

    public long getKeyId() {
        return this.getPublicKey().getKeyID();
    }

    public OpenPgpV4Fingerprint getFingerprint() {
        return new OpenPgpV4Fingerprint(this.getPublicKey());
    }

    public String getPrimaryUserId() throws PGPException {
        List<String> userIds = this.getValidUserIds();
        for (String userId : userIds) {
            PGPSignature signature = this.getLatestValidSignatureOnUserId(userId);
            if (!signature.getHashedSubPackets().isPrimaryUserID()) continue;
            return userId;
        }
        return null;
    }

    public List<String> getUserIds() {
        Iterator<String> iterator = this.getPublicKey().getUserIDs();
        List<String> userIds = CollectionUtils.iteratorToList(iterator);
        return userIds;
    }

    public List<String> getValidUserIds() {
        ArrayList<String> valid = new ArrayList<String>();
        List<String> userIds = this.getUserIds();
        for (String userId : userIds) {
            if (!this.isUserIdValid(userId)) continue;
            valid.add(userId);
        }
        return valid;
    }

    public boolean isUserIdValid(String userId) {
        return this.isUserIdValid(this.getKeyId(), userId);
    }

    public boolean isUserIdValid(long keyId, String userId) {
        try {
            return SignatureUtils.isUserIdValid(this.getPublicKey(keyId), userId);
        }
        catch (PGPException e) {
            return false;
        }
    }

    public List<String> getEmailAddresses() {
        List<String> userIds = this.getUserIds();
        ArrayList<String> emails = new ArrayList<String>();
        for (String userId : userIds) {
            Matcher matcher = PATTERN_EMAIL.matcher(userId);
            if (!matcher.find()) continue;
            emails.add(matcher.group());
        }
        return emails;
    }

    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.fromId(this.getPublicKey().getAlgorithm());
    }

    public Date getCreationDate() {
        return this.getPublicKey().getCreationTime();
    }

    public Date getLastModified() {
        Iterator signatures = this.getPublicKey().getSignatures();
        long last = 0L;
        while (signatures.hasNext()) {
            PGPSignature signature = (PGPSignature)signatures.next();
            if (this.getKeyId() != signature.getKeyID()) continue;
            last = Math.max(last, signature.getCreationTime().getTime());
        }
        return new Date(last);
    }

    public Date getRevocationDate() {
        Iterator revocations = this.getPublicKey().getSignaturesOfType(SignatureType.KEY_REVOCATION.getCode());
        while (revocations.hasNext()) {
            PGPSignature revocation = (PGPSignature)revocations.next();
            if (this.getKeyId() != revocation.getKeyID()) continue;
            return revocation.getCreationTime();
        }
        return null;
    }

    public Date getExpirationDate() {
        return this.getExpirationDate(new OpenPgpV4Fingerprint(this.getPublicKey()));
    }

    public Date getExpirationDate(OpenPgpV4Fingerprint fingerprint) {
        long validSeconds = this.keys.getPublicKey(fingerprint.getKeyId()).getValidSeconds();
        if (validSeconds == 0L) {
            return null;
        }
        return new Date(this.getCreationDate().getTime() + 1000L * validSeconds);
    }

    public boolean isSecretKey() {
        if (this.keys instanceof PGPSecretKeyRing) {
            return true;
        }
        if (this.keys instanceof PGPPublicKeyRing) {
            return false;
        }
        throw new AssertionError((Object)("Expected PGPKeyRing to be either PGPPublicKeyRing or PGPSecretKeyRing, but got " + this.keys.getClass().getName() + " instead."));
    }

    public boolean isFullyDecrypted() {
        if (this.isSecretKey()) {
            for (PGPSecretKey secretKey : this.getSecretKeys()) {
                if (secretKey.getS2KUsage() == 0) continue;
                return false;
            }
        }
        return true;
    }

    public List<PGPSignature> getSelfSignaturesOnKey(long subkeyId) {
        PGPPublicKey publicKey = KeyRingUtils.requirePublicKeyFrom(this.keys, subkeyId);
        Iterator<PGPSignature> it = publicKey.getSignaturesForKeyID(this.keys.getPublicKey().getKeyID());
        List<PGPSignature> signatures = CollectionUtils.iteratorToList(it);
        SignatureUtils.sortByCreationTimeAscending(signatures);
        return signatures;
    }

    public PGPSignature getLatestValidSelfSignatureOnKey() throws PGPException {
        return this.getLatestValidSelfSignatureOnKey(new OpenPgpV4Fingerprint(this.getPublicKey()));
    }

    public PGPSignature getLatestValidSelfSignatureOnKey(OpenPgpV4Fingerprint fingerprint) throws PGPException {
        return this.getLatestValidSelfSignatureOnKey(fingerprint.getKeyId());
    }

    public PGPSignature getLatestValidSelfSignatureOnKey(long subkeyId) throws PGPException {
        PGPPublicKey publicKey = KeyRingUtils.requirePublicKeyFrom(this.keys, subkeyId);
        List<PGPSignature> signatures = this.getSelfSignaturesOnKey(this.keys.getPublicKey().getKeyID());
        return SignatureUtils.getLatestValidSignature(publicKey, signatures, this.keys);
    }

    public PGPSignature getLatestValidSignatureOnUserId(String userId) throws PGPException {
        PGPPublicKey publicKey = KeyRingUtils.requirePrimaryPublicKeyFrom(this.keys);
        Iterator<PGPSignature> iterator = publicKey.getSignaturesForID(userId);
        List<PGPSignature> signatures = CollectionUtils.iteratorToList(iterator);
        return SignatureUtils.getLatestValidSignature(publicKey, signatures, this.keys);
    }

    public List<PGPSignature> getBindingSignaturesOnKey(OpenPgpV4Fingerprint fingerprint) {
        return this.getBindingSignaturesOnKey(fingerprint.getKeyId());
    }

    public List<PGPSignature> getBindingSignaturesOnKey(long subkeyId) {
        if (subkeyId == this.getKeyId()) {
            return Collections.emptyList();
        }
        PGPPublicKey publicKey = KeyRingUtils.requirePublicKeyFrom(this.keys, subkeyId);
        return SignatureUtils.getBindingSignatures(publicKey, this.getKeyId());
    }

    public PGPSignature getLatestValidBindingSignatureOnKey(long subKeyID) throws PGPException {
        PGPPublicKey publicKey = KeyRingUtils.requirePublicKeyFrom(this.keys, subKeyID);
        List<PGPSignature> signatures = this.getBindingSignaturesOnKey(subKeyID);
        return SignatureUtils.getLatestValidSignature(publicKey, signatures, this.keys);
    }

    public PGPSignature getLatestValidSelfOrBindingSignatureOnKey(OpenPgpV4Fingerprint fingerprint) throws PGPException {
        return this.getLatestValidSelfOrBindingSignatureOnKey(fingerprint.getKeyId());
    }

    public PGPSignature getLatestValidSelfOrBindingSignatureOnKey(long subKeyId) throws PGPException {
        PGPSignature self = this.getLatestValidSelfSignatureOnKey(subKeyId);
        PGPSignature binding = this.getLatestValidBindingSignatureOnKey(subKeyId);
        if (self == null) {
            return binding;
        }
        if (binding == null) {
            return self;
        }
        return self.getCreationTime().after(binding.getCreationTime()) ? self : binding;
    }
}

