/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.util.selection.key.impl.And;
import org.pgpainless.util.selection.key.impl.KeyBelongsToKeyRing;
import org.pgpainless.util.selection.key.impl.NoRevocation;

public class BCUtil {
    private static final Logger LOGGER = Logger.getLogger(BCUtil.class.getName());

    public static PGPPublicKeyRingCollection keyRingsToKeyRingCollection(PGPPublicKeyRing ... rings) throws IOException, PGPException {
        return new PGPPublicKeyRingCollection(Arrays.asList(rings));
    }

    public static PGPSecretKeyRingCollection keyRingsToKeyRingCollection(PGPSecretKeyRing ... rings) throws IOException, PGPException {
        return new PGPSecretKeyRingCollection(Arrays.asList(rings));
    }

    public static PGPSecretKeyRing getKeyRingFromCollection(@Nonnull PGPSecretKeyRingCollection collection, @Nonnull Long id) throws PGPException {
        PGPSecretKeyRing uncleanedRing = collection.getSecretKeyRing(id);
        HashSet<Long> signedKeyIds = new HashSet<Long>();
        signedKeyIds.add(id);
        Iterator<PGPPublicKey> signedPubKeys = uncleanedRing.getKeysWithSignaturesBy(id);
        while (signedPubKeys.hasNext()) {
            signedKeyIds.add(signedPubKeys.next().getKeyID());
        }
        PGPSecretKeyRing cleanedRing = uncleanedRing;
        Iterator<PGPSecretKey> secretKeys = uncleanedRing.getSecretKeys();
        while (secretKeys.hasNext()) {
            PGPSecretKey secretKey = secretKeys.next();
            if (signedKeyIds.contains(secretKey.getKeyID())) continue;
            cleanedRing = PGPSecretKeyRing.removeSecretKey(cleanedRing, secretKey);
        }
        return cleanedRing;
    }

    public static PGPPublicKeyRing getKeyRingFromCollection(@Nonnull PGPPublicKeyRingCollection collection, @Nonnull Long id) throws PGPException {
        PGPPublicKey key = collection.getPublicKey(id);
        return BCUtil.removeUnassociatedKeysFromKeyRing(collection.getPublicKeyRing(id), key);
    }

    public static InputStream getPgpDecoderInputStream(@Nonnull byte[] bytes) throws IOException {
        return BCUtil.getPgpDecoderInputStream(new ByteArrayInputStream(bytes));
    }

    public static InputStream getPgpDecoderInputStream(@Nonnull InputStream inputStream) throws IOException {
        return PGPUtil.getDecoderStream(inputStream);
    }

    public static byte[] getDecodedBytes(@Nonnull byte[] bytes) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Streams.pipeAll(BCUtil.getPgpDecoderInputStream(bytes), buffer);
        return buffer.toByteArray();
    }

    public static byte[] getDecodedBytes(@Nonnull InputStream inputStream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Streams.pipeAll(inputStream, buffer);
        return BCUtil.getDecodedBytes(buffer.toByteArray());
    }

    public static PGPPublicKeyRing removeUnassociatedKeysFromKeyRing(@Nonnull PGPPublicKeyRing ring, @Nonnull PGPPublicKey masterKey) {
        if (!masterKey.isMasterKey()) {
            throw new IllegalArgumentException("Given key is not a master key.");
        }
        And.PubKeySelectionStrategy selector = new And.PubKeySelectionStrategy(new KeyBelongsToKeyRing.PubkeySelectionStrategy(masterKey), new NoRevocation.PubKeySelectionStrategy());
        PGPPublicKeyRing cleaned = ring;
        Iterator<PGPPublicKey> publicKeys = ring.getPublicKeys();
        while (publicKeys.hasNext()) {
            PGPPublicKey publicKey = publicKeys.next();
            if (selector.accept(publicKey)) continue;
            cleaned = PGPPublicKeyRing.removePublicKey(cleaned, publicKey);
        }
        return cleaned;
    }

    public static PGPSecretKeyRing removeUnassociatedKeysFromKeyRing(@Nonnull PGPSecretKeyRing ring, @Nonnull PGPPublicKey masterKey) {
        if (!masterKey.isMasterKey()) {
            throw new IllegalArgumentException("Given key is not a master key.");
        }
        And.PubKeySelectionStrategy selector = new And.PubKeySelectionStrategy(new KeyBelongsToKeyRing.PubkeySelectionStrategy(masterKey), new NoRevocation.PubKeySelectionStrategy());
        PGPSecretKeyRing cleaned = ring;
        Iterator<PGPSecretKey> secretKeys = ring.getSecretKeys();
        while (secretKeys.hasNext()) {
            PGPSecretKey secretKey = secretKeys.next();
            if (selector.accept(secretKey.getPublicKey())) continue;
            cleaned = PGPSecretKeyRing.removeSecretKey(cleaned, secretKey);
        }
        return cleaned;
    }

    public static PGPPublicKey getMasterKeyFrom(@Nonnull PGPKeyRing ring) {
        Iterator<PGPPublicKey> it = ring.getPublicKeys();
        while (it.hasNext()) {
            PGPPublicKey k = it.next();
            if (!k.isMasterKey()) continue;
            return k;
        }
        return null;
    }

    public static Set<Long> signingKeyIds(@Nonnull PGPSecretKeyRing ring) {
        HashSet<Long> ids = new HashSet<Long>();
        Iterator<PGPPublicKey> it = ring.getPublicKeys();
        while (it.hasNext()) {
            PGPPublicKey k = it.next();
            boolean signingKey = false;
            Iterator sit = k.getSignatures();
            while (sit.hasNext()) {
                PGPSignature s;
                Object n = sit.next();
                if (!(n instanceof PGPSignature) || !(s = (PGPSignature)n).hasSubpackets()) continue;
                try {
                    s.verifyCertification(ring.getPublicKey(s.getKeyID()));
                }
                catch (PGPException e) {
                    LOGGER.log(Level.WARNING, "Could not verify signature on " + Long.toHexString(k.getKeyID()) + " made by " + Long.toHexString(s.getKeyID()));
                    continue;
                }
                PGPSignatureSubpacketVector hashed = s.getHashedSubPackets();
                if (!KeyFlag.fromBitmask(hashed.getKeyFlags()).contains((Object)KeyFlag.SIGN_DATA)) continue;
                signingKey = true;
                break;
            }
            if (!signingKey) continue;
            ids.add(k.getKeyID());
        }
        return ids;
    }

    public static boolean keyRingContainsKeyWithId(@Nonnull PGPPublicKeyRing ring, long keyId) {
        return ring.getPublicKey(keyId) != null;
    }

    public static boolean keyRingContainsKeyWithId(@Nonnull PGPSecretKeyRing ring, long keyId) {
        return ring.getSecretKey(keyId) != null;
    }
}

