/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.HashSet;
import java.util.Set;

public final class NotationRegistry {
    private static NotationRegistry INSTANCE;
    private final Set<String> knownNotations = new HashSet<String>();

    private NotationRegistry() {
    }

    public static NotationRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NotationRegistry();
        }
        return INSTANCE;
    }

    public void addKnownNotation(String notationName) {
        if (notationName == null) {
            throw new NullPointerException("Notation name MUST NOT be null.");
        }
        this.knownNotations.add(notationName);
    }

    public boolean isKnownNotation(String notationName) {
        return this.knownNotations.contains(notationName);
    }

    public void clear() {
        this.knownNotations.clear();
    }
}

