/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.signature.DetachedSignature;
import org.pgpainless.signature.OnePassSignature;

public class OpenPgpMetadata {
    private final Set<Long> recipientKeyIds;
    private final OpenPgpV4Fingerprint decryptionFingerprint;
    private final List<OnePassSignature> onePassSignatures;
    private final List<DetachedSignature> detachedSignatures;
    private final SymmetricKeyAlgorithm symmetricKeyAlgorithm;
    private final CompressionAlgorithm compressionAlgorithm;
    private final FileInfo fileInfo;

    public OpenPgpMetadata(Set<Long> recipientKeyIds, OpenPgpV4Fingerprint decryptionFingerprint, SymmetricKeyAlgorithm symmetricKeyAlgorithm, CompressionAlgorithm algorithm, List<OnePassSignature> onePassSignatures, List<DetachedSignature> detachedSignatures, FileInfo fileInfo) {
        this.recipientKeyIds = Collections.unmodifiableSet(recipientKeyIds);
        this.decryptionFingerprint = decryptionFingerprint;
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
        this.compressionAlgorithm = algorithm;
        this.detachedSignatures = Collections.unmodifiableList(detachedSignatures);
        this.onePassSignatures = Collections.unmodifiableList(onePassSignatures);
        this.fileInfo = fileInfo;
    }

    public Set<Long> getRecipientKeyIds() {
        return this.recipientKeyIds;
    }

    public boolean isEncrypted() {
        return this.symmetricKeyAlgorithm != SymmetricKeyAlgorithm.NULL && !this.getRecipientKeyIds().isEmpty();
    }

    public OpenPgpV4Fingerprint getDecryptionFingerprint() {
        return this.decryptionFingerprint;
    }

    public SymmetricKeyAlgorithm getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public Set<PGPSignature> getSignatures() {
        HashSet<PGPSignature> signatures = new HashSet<PGPSignature>();
        for (DetachedSignature detachedSignature : this.detachedSignatures) {
            signatures.add(detachedSignature.getSignature());
        }
        for (OnePassSignature onePassSignature : this.onePassSignatures) {
            signatures.add(onePassSignature.getSignature());
        }
        return signatures;
    }

    public boolean isSigned() {
        return !this.getSignatures().isEmpty();
    }

    public Map<OpenPgpV4Fingerprint, PGPSignature> getVerifiedSignatures() {
        ConcurrentHashMap<OpenPgpV4Fingerprint, PGPSignature> verifiedSignatures = new ConcurrentHashMap<OpenPgpV4Fingerprint, PGPSignature>();
        for (DetachedSignature detachedSignature : this.detachedSignatures) {
            if (!detachedSignature.isVerified()) continue;
            verifiedSignatures.put(detachedSignature.getFingerprint(), detachedSignature.getSignature());
        }
        for (OnePassSignature onePassSignature : this.onePassSignatures) {
            if (!onePassSignature.isVerified()) continue;
            verifiedSignatures.put(onePassSignature.getFingerprint(), onePassSignature.getSignature());
        }
        return verifiedSignatures;
    }

    public Set<OpenPgpV4Fingerprint> getVerifiedSignatureKeyFingerprints() {
        return this.getVerifiedSignatures().keySet();
    }

    public boolean isVerified() {
        return !this.getVerifiedSignatures().isEmpty();
    }

    public boolean containsVerifiedSignatureFrom(PGPPublicKeyRing publicKeys) {
        for (PGPPublicKey key : publicKeys) {
            OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(key);
            if (!this.containsVerifiedSignatureFrom(fingerprint)) continue;
            return true;
        }
        return false;
    }

    public boolean containsVerifiedSignatureFrom(OpenPgpV4Fingerprint fingerprint) {
        return this.getVerifiedSignatureKeyFingerprints().contains(fingerprint);
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<Long> recipientFingerprints = new HashSet<Long>();
        private OpenPgpV4Fingerprint decryptionFingerprint;
        private final List<DetachedSignature> detachedSignatures = new ArrayList<DetachedSignature>();
        private final List<OnePassSignature> onePassSignatures = new ArrayList<OnePassSignature>();
        private SymmetricKeyAlgorithm symmetricKeyAlgorithm = SymmetricKeyAlgorithm.NULL;
        private CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.UNCOMPRESSED;
        private FileInfo fileInfo;

        public Builder addRecipientKeyId(Long keyId) {
            this.recipientFingerprints.add(keyId);
            return this;
        }

        public Builder setDecryptionFingerprint(OpenPgpV4Fingerprint fingerprint) {
            this.decryptionFingerprint = fingerprint;
            return this;
        }

        public Builder setCompressionAlgorithm(CompressionAlgorithm algorithm) {
            this.compressionAlgorithm = algorithm;
            return this;
        }

        public List<DetachedSignature> getDetachedSignatures() {
            return this.detachedSignatures;
        }

        public Builder setSymmetricKeyAlgorithm(SymmetricKeyAlgorithm symmetricKeyAlgorithm) {
            this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
            return this;
        }

        public void addDetachedSignature(DetachedSignature signature) {
            this.detachedSignatures.add(signature);
        }

        public void addOnePassSignature(OnePassSignature onePassSignature) {
            this.onePassSignatures.add(onePassSignature);
        }

        public Builder setFileInfo(FileInfo fileInfo) {
            this.fileInfo = fileInfo;
            return this;
        }

        public OpenPgpMetadata build() {
            return new OpenPgpMetadata(this.recipientFingerprints, this.decryptionFingerprint, this.symmetricKeyAlgorithm, this.compressionAlgorithm, this.onePassSignatures, this.detachedSignatures, this.fileInfo);
        }
    }

    public static class FileInfo {
        public static final String FOR_YOUR_EYES_ONLY = "_CONSOLE";
        protected final String fileName;
        protected final Date modicationDate;
        protected final StreamEncoding streamEncoding;

        public FileInfo(String fileName, Date modicationDate, StreamEncoding streamEncoding) {
            this.fileName = fileName == null ? "" : fileName;
            this.modicationDate = modicationDate == null ? PGPLiteralData.NOW : modicationDate;
            this.streamEncoding = streamEncoding;
        }

        public static FileInfo binaryStream() {
            return new FileInfo("", null, StreamEncoding.BINARY);
        }

        public static FileInfo forYourEyesOnly() {
            return new FileInfo(FOR_YOUR_EYES_ONLY, null, StreamEncoding.BINARY);
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isForYourEyesOnly() {
            return FOR_YOUR_EYES_ONLY.equals(this.fileName);
        }

        public Date getModificationDate() {
            return this.modicationDate;
        }

        public StreamEncoding getStreamFormat() {
            return this.streamEncoding;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileInfo)) {
                return false;
            }
            FileInfo o = (FileInfo)other;
            if (this.getFileName() != null ? !this.getFileName().equals(o.getFileName()) : o.getFileName() != null) {
                return false;
            }
            if (this.getModificationDate() != null) {
                if (o.getModificationDate() == null) {
                    return false;
                }
                long diff = Math.abs(this.getModificationDate().getTime() - o.getModificationDate().getTime());
                if (diff > 1000L) {
                    return false;
                }
            } else if (o.getModificationDate() != null) {
                return false;
            }
            return this.getStreamFormat() == o.getStreamFormat();
        }
    }

    public static class Signature {
        protected final PGPSignature signature;
        protected final OpenPgpV4Fingerprint fingerprint;

        public Signature(PGPSignature signature, OpenPgpV4Fingerprint fingerprint) {
            this.signature = signature;
            this.fingerprint = fingerprint;
        }
    }
}

