/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.SymmetricKeyAlgorithmNegotiator;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionBuilderInterface;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyValidationException;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;

public class EncryptionBuilder
implements EncryptionBuilderInterface {
    private OutputStream outputStream;
    private EncryptionOptions encryptionOptions;
    private SigningOptions signingOptions = new SigningOptions();
    private ProducerOptions options;
    private OpenPgpMetadata.FileInfo fileInfo;

    public EncryptionBuilder() {
        this.encryptionOptions = new EncryptionOptions(EncryptionPurpose.COMMUNICATIONS);
    }

    public EncryptionBuilder(@Nonnull EncryptionPurpose purpose) {
        this.encryptionOptions = new EncryptionOptions(purpose);
    }

    @Override
    public EncryptionBuilderInterface.ToRecipientsOrNoEncryption onOutputStream(@Nonnull OutputStream outputStream, OpenPgpMetadata.FileInfo fileInfo) {
        this.outputStream = outputStream;
        this.fileInfo = fileInfo;
        return new ToRecipientsOrNoEncryptionImpl();
    }

    public static SymmetricKeyAlgorithm negotiateSymmetricEncryptionAlgorithm(EncryptionOptions encryptionOptions) {
        ArrayList<Set<SymmetricKeyAlgorithm>> preferences = new ArrayList<Set<SymmetricKeyAlgorithm>>();
        for (SubkeyIdentifier key : encryptionOptions.getKeyViews().keySet()) {
            preferences.add(encryptionOptions.getKeyViews().get(key).getPreferredSymmetricKeyAlgorithms());
        }
        return SymmetricKeyAlgorithmNegotiator.byPopularity().negotiate(PGPainless.getPolicy().getSymmetricKeyEncryptionAlgorithmPolicy(), encryptionOptions.getEncryptionAlgorithmOverride(), preferences);
    }

    public static CompressionAlgorithm negotiateCompressionAlgorithm(ProducerOptions producerOptions) {
        CompressionAlgorithm compressionAlgorithmOverride = producerOptions.getCompressionAlgorithmOverride();
        if (compressionAlgorithmOverride != null) {
            return compressionAlgorithmOverride;
        }
        return PGPainless.getPolicy().getCompressionAlgorithmPolicy().defaultCompressionAlgorithm();
    }

    class ArmorImpl
    implements EncryptionBuilderInterface.Armor {
        ArmorImpl() {
        }

        @Override
        public EncryptionStream asciiArmor() throws IOException, PGPException {
            this.assignProducerOptions();
            EncryptionBuilder.this.options.setAsciiArmor(true);
            return this.build();
        }

        @Override
        public EncryptionStream noArmor() throws IOException, PGPException {
            this.assignProducerOptions();
            EncryptionBuilder.this.options.setAsciiArmor(false);
            return this.build();
        }

        private EncryptionStream build() throws IOException, PGPException {
            return new EncryptionStream(EncryptionBuilder.this.outputStream, EncryptionBuilder.this.options, EncryptionBuilder.this.fileInfo);
        }

        private void assignProducerOptions() {
            if (EncryptionBuilder.this.encryptionOptions != null && EncryptionBuilder.this.signingOptions != null) {
                EncryptionBuilder.this.options = ProducerOptions.signAndEncrypt(EncryptionBuilder.this.encryptionOptions, EncryptionBuilder.this.signingOptions);
            } else if (EncryptionBuilder.this.encryptionOptions != null) {
                EncryptionBuilder.this.options = ProducerOptions.encrypt(EncryptionBuilder.this.encryptionOptions);
            } else if (EncryptionBuilder.this.signingOptions != null) {
                EncryptionBuilder.this.options = ProducerOptions.sign(EncryptionBuilder.this.signingOptions);
            } else {
                EncryptionBuilder.this.options = ProducerOptions.noEncryptionNoSigning();
            }
        }
    }

    class AdditionalSignWithImpl
    implements EncryptionBuilderInterface.AdditionalSignWith {
        AdditionalSignWithImpl() {
        }

        @Override
        public EncryptionBuilderInterface.SignWith and() {
            return new SignWithImpl();
        }

        @Override
        public EncryptionStream asciiArmor() throws IOException, PGPException {
            return new ArmorImpl().asciiArmor();
        }

        @Override
        public EncryptionStream noArmor() throws IOException, PGPException {
            return new ArmorImpl().noArmor();
        }
    }

    class SignWithImpl
    implements EncryptionBuilderInterface.SignWith {
        SignWithImpl() {
        }

        @Override
        public EncryptionBuilderInterface.AdditionalSignWith signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKeyRing ... keyRings) throws KeyValidationException, PGPException {
            for (PGPSecretKeyRing secretKeyRing : keyRings) {
                EncryptionBuilder.this.signingOptions.addInlineSignature(decryptor, secretKeyRing, DocumentSignatureType.BINARY_DOCUMENT);
            }
            return new AdditionalSignWithImpl();
        }

        @Override
        public EncryptionBuilderInterface.AdditionalSignWith signWith(@Nonnull SecretKeyRingProtector decryptor, @Nonnull PGPSecretKeyRingCollection keyRings) throws KeyValidationException, PGPException {
            for (PGPSecretKeyRing key : keyRings) {
                EncryptionBuilder.this.signingOptions.addInlineSignature(decryptor, key, DocumentSignatureType.BINARY_DOCUMENT);
            }
            return new AdditionalSignWithImpl();
        }

        @Override
        public EncryptionBuilderInterface.AdditionalSignWith signInlineWith(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing signingKey, String userId, DocumentSignatureType signatureType) throws KeyValidationException, PGPException {
            EncryptionBuilder.this.signingOptions.addInlineSignature(secretKeyDecryptor, signingKey, userId, signatureType);
            return new AdditionalSignWithImpl();
        }

        @Override
        public EncryptionBuilderInterface.AdditionalSignWith signDetachedWith(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing signingKey, String userId, DocumentSignatureType signatureType) throws PGPException, KeyValidationException {
            EncryptionBuilder.this.signingOptions.addDetachedSignature(secretKeyDecryptor, signingKey, userId, signatureType);
            return new AdditionalSignWithImpl();
        }
    }

    class SignWithOrDontSignImpl
    extends SignWithImpl
    implements EncryptionBuilderInterface.SignWithOrDontSign {
        SignWithOrDontSignImpl() {
        }

        @Override
        public EncryptionBuilderInterface.Armor doNotSign() {
            return new ArmorImpl();
        }
    }

    class ToRecipientsOrSignImpl
    extends ToRecipientsImpl
    implements EncryptionBuilderInterface.ToRecipientsOrSign {
        ToRecipientsOrSignImpl() {
        }

        @Override
        public EncryptionBuilderInterface.Armor doNotSign() {
            EncryptionBuilder.this.signingOptions = null;
            return new ArmorImpl();
        }

        @Override
        public EncryptionBuilderInterface.AdditionalSignWith signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKeyRing ... keyRings) throws KeyValidationException, PGPException {
            return new SignWithImpl().signWith(decryptor, keyRings);
        }

        @Override
        public EncryptionBuilderInterface.AdditionalSignWith signWith(@Nonnull SecretKeyRingProtector decryptor, @Nonnull PGPSecretKeyRingCollection keyRings) throws PGPException {
            return new SignWithImpl().signWith(decryptor, keyRings);
        }

        @Override
        public EncryptionBuilderInterface.AdditionalSignWith signInlineWith(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing signingKey, String userId, DocumentSignatureType signatureType) throws PGPException {
            return new SignWithImpl().signInlineWith(secretKeyDecryptor, signingKey, userId, signatureType);
        }

        @Override
        public EncryptionBuilderInterface.AdditionalSignWith signDetachedWith(@Nonnull SecretKeyRingProtector secretKeyDecryptor, @Nonnull PGPSecretKeyRing signingKey, String userId, DocumentSignatureType signatureType) throws PGPException {
            return new SignWithImpl().signDetachedWith(secretKeyDecryptor, signingKey, userId, signatureType);
        }
    }

    class AdditionalRecipientsImpl
    implements EncryptionBuilderInterface.AdditionalRecipients {
        AdditionalRecipientsImpl() {
        }

        @Override
        public EncryptionBuilderInterface.ToRecipientsOrSign and() {
            return new ToRecipientsOrSignImpl();
        }
    }

    class ToRecipientsOrNoEncryptionImpl
    extends ToRecipientsImpl
    implements EncryptionBuilderInterface.ToRecipientsOrNoEncryption {
        ToRecipientsOrNoEncryptionImpl() {
        }

        @Override
        public EncryptionStream withOptions(ProducerOptions options) throws PGPException, IOException {
            if (options == null) {
                throw new NullPointerException("ProducerOptions cannot be null.");
            }
            return new EncryptionStream(EncryptionBuilder.this.outputStream, options, EncryptionBuilder.this.fileInfo);
        }

        @Override
        public EncryptionBuilderInterface.SignWithOrDontSign doNotEncrypt() {
            EncryptionBuilder.this.encryptionOptions = null;
            return new SignWithOrDontSignImpl();
        }
    }

    class ToRecipientsImpl
    implements EncryptionBuilderInterface.ToRecipients {
        ToRecipientsImpl() {
        }

        @Override
        public EncryptionBuilderInterface.AdditionalRecipients toRecipient(@Nonnull PGPPublicKeyRing key) {
            EncryptionBuilder.this.encryptionOptions.addRecipient(key);
            return new AdditionalRecipientsImpl();
        }

        @Override
        public EncryptionBuilderInterface.AdditionalRecipients toRecipient(@Nonnull PGPPublicKeyRing key, @Nonnull String userId) {
            EncryptionBuilder.this.encryptionOptions.addRecipient(key, userId);
            return new AdditionalRecipientsImpl();
        }

        @Override
        public EncryptionBuilderInterface.AdditionalRecipients toRecipient(@Nonnull PGPPublicKeyRingCollection keys, @Nonnull String userId) {
            for (PGPPublicKeyRing ring : keys) {
                EncryptionBuilder.this.encryptionOptions.addRecipient(ring, userId);
            }
            return new AdditionalRecipientsImpl();
        }

        @Override
        public EncryptionBuilderInterface.AdditionalRecipients toRecipients(@Nonnull PGPPublicKeyRingCollection keys) {
            for (PGPPublicKeyRing ring : keys) {
                EncryptionBuilder.this.encryptionOptions.addRecipient(ring);
            }
            return new AdditionalRecipientsImpl();
        }

        @Override
        public EncryptionBuilderInterface.AdditionalRecipients forPassphrase(Passphrase passphrase) {
            EncryptionBuilder.this.encryptionOptions.addPassphrase(passphrase);
            return new AdditionalRecipientsImpl();
        }
    }
}

