/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.SignatureCreationDateComparator;
import org.pgpainless.signature.SignatureValidator;
import org.pgpainless.util.CollectionUtils;

public class KeyRingValidator {
    private static final Logger LOGGER = Logger.getLogger(KeyRingValidator.class.getName());

    public static <R extends PGPKeyRing> R validate(R keyRing, Policy policy) {
        try {
            return KeyRingValidator.validate(keyRing, policy, new Date());
        }
        catch (PGPException e) {
            return null;
        }
    }

    public static <R extends PGPKeyRing> R validate(R keyRing, Policy policy, Date validationDate) throws PGPException {
        return KeyRingValidator.getKeyRingAtDate(keyRing, policy, validationDate);
    }

    private static <R extends PGPKeyRing> R getKeyRingAtDate(R keyRing, Policy policy, Date validationDate) throws PGPException {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        primaryKey = KeyRingValidator.evaluatePrimaryKey(primaryKey, policy, validationDate);
        if (keyRing instanceof PGPPublicKeyRing) {
            PGPPublicKeyRing publicKeys = (PGPPublicKeyRing)keyRing;
            publicKeys = PGPPublicKeyRing.insertPublicKey(publicKeys, primaryKey);
            keyRing = publicKeys;
        }
        return keyRing;
    }

    private static PGPPublicKey evaluatePrimaryKey(PGPPublicKey primaryKey, Policy policy, Date validationDate) throws PGPException {
        PGPPublicKey blank = new PGPPublicKey(primaryKey.getPublicKeyPacket(), ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        Iterator directKeyIterator = primaryKey.getSignaturesOfType(SignatureType.DIRECT_KEY.getCode());
        List<PGPSignature> directKeyCertifications = CollectionUtils.iteratorToList(directKeyIterator);
        Collections.sort(directKeyCertifications, new SignatureCreationDateComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
        for (PGPSignature signature : directKeyCertifications) {
            try {
                if (!SignatureValidator.verifyDirectKeySignature(signature, blank, policy, validationDate)) continue;
                blank = PGPPublicKey.addCertification(blank, signature);
            }
            catch (SignatureValidationException e) {
                LOGGER.log(Level.INFO, "Rejecting direct key signature", e);
            }
        }
        Iterator revocationIterator = primaryKey.getSignaturesOfType(SignatureType.KEY_REVOCATION.getCode());
        List<PGPSignature> directKeyRevocations = CollectionUtils.iteratorToList(revocationIterator);
        Collections.sort(directKeyRevocations, new SignatureCreationDateComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
        for (PGPSignature signature : directKeyRevocations) {
            try {
                if (!SignatureValidator.verifyKeyRevocationSignature(signature, primaryKey, policy, validationDate)) continue;
                blank = PGPPublicKey.addCertification(blank, signature);
            }
            catch (SignatureValidationException e) {
                LOGGER.log(Level.INFO, "Rejecting key revocation signature", e);
            }
        }
        Iterator<String> userIdIterator = primaryKey.getUserIDs();
        while (userIdIterator.hasNext()) {
            String userId = userIdIterator.next();
            Iterator<PGPSignature> userIdSigs = primaryKey.getSignaturesForID(userId);
            List<PGPSignature> signatures = CollectionUtils.iteratorToList(userIdSigs);
            Collections.sort(signatures, new SignatureCreationDateComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
            for (PGPSignature signature : signatures) {
                try {
                    if (SignatureType.valueOf(signature.getSignatureType()) == SignatureType.CERTIFICATION_REVOCATION) {
                        if (!SignatureValidator.verifyUserIdRevocation(userId, signature, primaryKey, policy, validationDate)) continue;
                        blank = PGPPublicKey.addCertification(blank, userId, signature);
                        continue;
                    }
                    if (!SignatureValidator.verifyUserIdCertification(userId, signature, primaryKey, policy, validationDate)) continue;
                    blank = PGPPublicKey.addCertification(blank, userId, signature);
                }
                catch (SignatureValidationException e) {
                    LOGGER.log(Level.FINE, "Rejecting user-id certification for user-id " + userId, e);
                }
            }
        }
        Iterator<PGPUserAttributeSubpacketVector> userAttributes = primaryKey.getUserAttributes();
        while (userAttributes.hasNext()) {
            PGPUserAttributeSubpacketVector userAttribute = userAttributes.next();
            Iterator userAttributeSignatureIterator = primaryKey.getSignaturesForUserAttribute(userAttribute);
            while (userAttributeSignatureIterator.hasNext()) {
                PGPSignature signature = (PGPSignature)userAttributeSignatureIterator.next();
                try {
                    if (SignatureType.valueOf(signature.getSignatureType()) == SignatureType.CERTIFICATION_REVOCATION) {
                        if (!SignatureValidator.verifyUserAttributesRevocation(userAttribute, signature, primaryKey, policy, validationDate)) continue;
                        blank = PGPPublicKey.addCertification(blank, userAttribute, signature);
                        continue;
                    }
                    if (!SignatureValidator.verifyUserAttributesCertification(userAttribute, signature, primaryKey, policy, validationDate)) continue;
                    blank = PGPPublicKey.addCertification(blank, userAttribute, signature);
                }
                catch (SignatureValidationException e) {
                    LOGGER.log(Level.INFO, "Rejecting user-attribute signature", e);
                }
            }
        }
        return blank;
    }
}

