/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeyRingBuilderInterface;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.key.util.UserId;
import org.pgpainless.provider.ProviderFactory;
import org.pgpainless.signature.subpackets.SignatureSubpacketGeneratorUtil;
import org.pgpainless.util.Passphrase;

public class KeyRingBuilder
implements KeyRingBuilderInterface {
    private static final Logger LOGGER = Logger.getLogger(KeyRingBuilder.class.getName());
    private final Charset UTF8 = Charset.forName("UTF-8");
    private final List<KeySpec> keySpecs = new ArrayList<KeySpec>();
    private String userId;
    private final Set<String> additionalUserIds = new LinkedHashSet<String>();
    private Passphrase passphrase;
    private Date expirationDate = null;

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull UserId userId, @Nonnull RsaLength length) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleRsaKeyRing(userId.toString(), length);
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull String userId, @Nonnull RsaLength length) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleRsaKeyRing(userId, length, null);
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull UserId userId, @Nonnull RsaLength length, String password) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleRsaKeyRing(userId.toString(), length, password);
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull String userId, @Nonnull RsaLength length, String password) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase builder = this.withPrimaryKey(KeySpec.getBuilder(KeyType.RSA(length)).withKeyFlags(KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_COMMS).withDefaultAlgorithms()).withPrimaryUserId(userId);
        if (password == null) {
            return builder.withoutPassphrase().build();
        }
        return builder.withPassphrase(new Passphrase(password.toCharArray())).build();
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull UserId userId) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleEcKeyRing(userId.toString());
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull String userId) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleEcKeyRing(userId, null);
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull UserId userId, String password) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleEcKeyRing(userId.toString(), password);
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull String userId, String password) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase builder = this.withSubKey(KeySpec.getBuilder(KeyType.XDH(XDHSpec._X25519)).withKeyFlags(KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS).withDefaultAlgorithms()).withPrimaryKey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519)).withKeyFlags(KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA).withDefaultAlgorithms()).withPrimaryUserId(userId);
        if (password == null) {
            return builder.withoutPassphrase().build();
        }
        return builder.withPassphrase(new Passphrase(password.toCharArray())).build();
    }

    public PGPSecretKeyRing modernKeyRing(String userId, String password) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase builder = this.withSubKey(KeySpec.getBuilder(KeyType.XDH(XDHSpec._X25519)).withKeyFlags(KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS).withDefaultAlgorithms()).withSubKey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519)).withKeyFlags(KeyFlag.SIGN_DATA).withDefaultAlgorithms()).withPrimaryKey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519)).withKeyFlags(KeyFlag.CERTIFY_OTHER).withDefaultAlgorithms()).withPrimaryUserId(userId);
        if (password == null) {
            return builder.withoutPassphrase().build();
        }
        return builder.withPassphrase(new Passphrase(password.toCharArray())).build();
    }

    @Override
    public KeyRingBuilderInterface withSubKey(@Nonnull KeySpec type) {
        this.keySpecs.add(type);
        return this;
    }

    @Override
    public KeyRingBuilderInterface.WithPrimaryUserId withPrimaryKey(@Nonnull KeySpec spec) {
        this.verifyMasterKeyCanCertify(spec);
        this.keySpecs.add(0, spec);
        return new WithPrimaryUserIdImpl();
    }

    private void verifyMasterKeyCanCertify(KeySpec spec) {
        if (!this.hasCertifyOthersFlag(spec)) {
            throw new IllegalArgumentException("Certification Key MUST have KeyFlag CERTIFY_OTHER");
        }
        if (!this.keyIsCertificationCapable(spec)) {
            throw new IllegalArgumentException("Key algorithm " + spec.getKeyType().getName() + " is not capable of creating certifications.");
        }
    }

    private boolean hasCertifyOthersFlag(KeySpec keySpec) {
        return SignatureSubpacketGeneratorUtil.hasKeyFlag(KeyFlag.CERTIFY_OTHER, keySpec.getSubpacketGenerator());
    }

    private boolean keyIsCertificationCapable(KeySpec keySpec) {
        return keySpec.getKeyType().canCertify();
    }

    public static PGPKeyPair generateKeyPair(KeySpec spec) throws NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
        PGPKeyPair pgpKeyPair;
        KeyType type = spec.getKeyType();
        KeyPairGenerator certKeyGenerator = KeyPairGenerator.getInstance(type.getName(), ProviderFactory.getProvider());
        certKeyGenerator.initialize(type.getAlgorithmSpec());
        KeyPair keyPair = certKeyGenerator.generateKeyPair();
        try {
            pgpKeyPair = ImplementationFactory.getInstance().getPGPKeyPair(type.getAlgorithm(), keyPair, new Date());
        }
        catch (PGPException e) {
            LOGGER.log(Level.INFO, "Generated private key encoding has incorrect length. Trying again.");
            LOGGER.log(Level.FINER, "Incorrect private key encoding length is caused by a bug in Bouncycastle. See https://github.com/bcgit/bc-java/issues/887", e);
            pgpKeyPair = KeyRingBuilder.generateKeyPair(spec);
        }
        return pgpKeyPair;
    }

    class WithAdditionalUserIdOrPassphraseImpl
    implements KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase {
        WithAdditionalUserIdOrPassphraseImpl() {
        }

        @Override
        public KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase setExpirationDate(@Nonnull Date expirationDate) {
            Date now = new Date();
            if (now.after(expirationDate)) {
                throw new IllegalArgumentException("Expiration date must be in the future.");
            }
            KeyRingBuilder.this.expirationDate = expirationDate;
            return this;
        }

        @Override
        public KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase withAdditionalUserId(@Nonnull String userId) {
            String trimmed = userId.trim();
            if (KeyRingBuilder.this.userId.equals(trimmed)) {
                throw new IllegalArgumentException("Additional user-id MUST NOT be equal to primary user-id.");
            }
            KeyRingBuilder.this.additionalUserIds.add(trimmed);
            return this;
        }

        @Override
        public KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase withAdditionalUserId(@Nonnull byte[] userId) {
            return this.withAdditionalUserId(new String(userId, KeyRingBuilder.this.UTF8));
        }

        @Override
        public KeyRingBuilderInterface.Build withPassphrase(@Nonnull Passphrase passphrase) {
            KeyRingBuilder.this.passphrase = passphrase;
            return new BuildImpl();
        }

        @Override
        public KeyRingBuilderInterface.Build withoutPassphrase() {
            KeyRingBuilder.this.passphrase = null;
            return new BuildImpl();
        }

        class BuildImpl
        implements KeyRingBuilderInterface.Build {
            private PGPSignatureGenerator signatureGenerator;
            private PGPDigestCalculator digestCalculator;
            private PBESecretKeyEncryptor secretKeyEncryptor;

            BuildImpl() {
            }

            @Override
            public PGPSecretKeyRing build() throws NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
                this.digestCalculator = this.buildDigestCalculator();
                this.secretKeyEncryptor = this.buildSecretKeyEncryptor();
                PBESecretKeyDecryptor secretKeyDecryptor = this.buildSecretKeyDecryptor();
                if (KeyRingBuilder.this.passphrase != null) {
                    KeyRingBuilder.this.passphrase.clear();
                }
                KeySpec certKeySpec = (KeySpec)KeyRingBuilder.this.keySpecs.remove(0);
                PGPKeyPair certKey = KeyRingBuilder.generateKeyPair(certKeySpec);
                PGPContentSignerBuilder signer = this.buildContentSigner(certKey);
                this.signatureGenerator = new PGPSignatureGenerator(signer);
                PGPSignatureSubpacketGenerator hashedSubPacketGenerator = certKeySpec.getSubpacketGenerator();
                hashedSubPacketGenerator.setPrimaryUserID(false, true);
                if (KeyRingBuilder.this.expirationDate != null) {
                    SignatureSubpacketGeneratorUtil.setExpirationDateInSubpacketGenerator(KeyRingBuilder.this.expirationDate, new Date(), hashedSubPacketGenerator);
                }
                PGPSignatureSubpacketVector hashedSubPackets = hashedSubPacketGenerator.generate();
                PGPKeyRingGenerator ringGenerator = this.buildRingGenerator(certKey, signer, hashedSubPackets);
                this.addSubKeys(certKey, ringGenerator);
                PGPSecretKeyRing secretKeyRing = ringGenerator.generateSecretKeyRing();
                Iterator<PGPSecretKey> secretKeys = secretKeyRing.getSecretKeys();
                PGPPublicKey primaryPubKey = secretKeys.next().getPublicKey();
                PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey(secretKeyRing.getSecretKey(), secretKeyDecryptor);
                for (String additionalUserId : KeyRingBuilder.this.additionalUserIds) {
                    this.signatureGenerator.init(SignatureType.POSITIVE_CERTIFICATION.getCode(), privateKey);
                    PGPSignature additionalUserIdSignature = this.signatureGenerator.generateCertification(additionalUserId, primaryPubKey);
                    primaryPubKey = PGPPublicKey.addCertification(primaryPubKey, additionalUserId, additionalUserIdSignature);
                }
                PGPSecretKey primarySecKey = new PGPSecretKey(privateKey, primaryPubKey, this.digestCalculator, true, this.secretKeyEncryptor);
                ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
                secretKeyList.add(primarySecKey);
                while (secretKeys.hasNext()) {
                    secretKeyList.add(secretKeys.next());
                }
                secretKeyRing = new PGPSecretKeyRing(secretKeyList);
                return secretKeyRing;
            }

            private PGPKeyRingGenerator buildRingGenerator(PGPKeyPair certKey, PGPContentSignerBuilder signer, PGPSignatureSubpacketVector hashedSubPackets) throws PGPException {
                return new PGPKeyRingGenerator(SignatureType.POSITIVE_CERTIFICATION.getCode(), certKey, KeyRingBuilder.this.userId, this.digestCalculator, hashedSubPackets, null, signer, this.secretKeyEncryptor);
            }

            private void addSubKeys(PGPKeyPair primaryKey, PGPKeyRingGenerator ringGenerator) throws NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
                for (KeySpec subKeySpec : KeyRingBuilder.this.keySpecs) {
                    PGPKeyPair subKey = KeyRingBuilder.generateKeyPair(subKeySpec);
                    if (subKeySpec.isInheritedSubPackets()) {
                        ringGenerator.addSubKey(subKey);
                        continue;
                    }
                    PGPSignatureSubpacketVector hashedSubpackets = subKeySpec.getSubpackets();
                    try {
                        hashedSubpackets = this.addPrimaryKeyBindingSignatureIfNecessary(primaryKey, subKey, hashedSubpackets);
                    }
                    catch (IOException e) {
                        throw new PGPException("Exception while adding primary key binding signature to signing subkey", e);
                    }
                    ringGenerator.addSubKey(subKey, hashedSubpackets, null);
                }
            }

            private PGPSignatureSubpacketVector addPrimaryKeyBindingSignatureIfNecessary(PGPKeyPair primaryKey, PGPKeyPair subKey, PGPSignatureSubpacketVector hashedSubpackets) throws PGPException, IOException {
                int keyFlagMask = hashedSubpackets.getKeyFlags();
                if (!KeyFlag.hasKeyFlag(keyFlagMask, KeyFlag.SIGN_DATA) && !KeyFlag.hasKeyFlag(keyFlagMask, KeyFlag.CERTIFY_OTHER)) {
                    return hashedSubpackets;
                }
                PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(this.buildContentSigner(subKey));
                signatureGenerator.init(SignatureType.PRIMARYKEY_BINDING.getCode(), subKey.getPrivateKey());
                PGPSignature primaryKeyBindingSig = signatureGenerator.generateCertification(primaryKey.getPublicKey(), subKey.getPublicKey());
                PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator(hashedSubpackets);
                subpacketGenerator.addEmbeddedSignature(false, primaryKeyBindingSig);
                return subpacketGenerator.generate();
            }

            private PGPContentSignerBuilder buildContentSigner(PGPKeyPair certKey) {
                HashAlgorithm hashAlgorithm = PGPainless.getPolicy().getSignatureHashAlgorithmPolicy().defaultHashAlgorithm();
                return ImplementationFactory.getInstance().getPGPContentSignerBuilder(certKey.getPublicKey().getAlgorithm(), hashAlgorithm.getAlgorithmId());
            }

            private PBESecretKeyEncryptor buildSecretKeyEncryptor() {
                SymmetricKeyAlgorithm keyEncryptionAlgorithm = PGPainless.getPolicy().getSymmetricKeyEncryptionAlgorithmPolicy().getDefaultSymmetricKeyAlgorithm();
                PBESecretKeyEncryptor encryptor = KeyRingBuilder.this.passphrase == null || KeyRingBuilder.this.passphrase.isEmpty() ? null : ImplementationFactory.getInstance().getPBESecretKeyEncryptor(keyEncryptionAlgorithm, this.digestCalculator, KeyRingBuilder.this.passphrase);
                return encryptor;
            }

            private PBESecretKeyDecryptor buildSecretKeyDecryptor() throws PGPException {
                PBESecretKeyDecryptor decryptor = KeyRingBuilder.this.passphrase == null || KeyRingBuilder.this.passphrase.isEmpty() ? null : ImplementationFactory.getInstance().getPBESecretKeyDecryptor(KeyRingBuilder.this.passphrase);
                return decryptor;
            }

            private PGPDigestCalculator buildDigestCalculator() throws PGPException {
                return ImplementationFactory.getInstance().getPGPDigestCalculator(HashAlgorithm.SHA1);
            }
        }
    }

    class WithPrimaryUserIdImpl
    implements KeyRingBuilderInterface.WithPrimaryUserId {
        WithPrimaryUserIdImpl() {
        }

        @Override
        public KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase withPrimaryUserId(@Nonnull String userId) {
            KeyRingBuilder.this.userId = userId.trim();
            return new WithAdditionalUserIdOrPassphraseImpl();
        }

        @Override
        public KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase withPrimaryUserId(@Nonnull byte[] userId) {
            return this.withPrimaryUserId(new String(userId, KeyRingBuilder.this.UTF8));
        }
    }
}

