/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureSubpacket;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.NotationRegistry;

public abstract class SignatureValidator {
    public abstract void verify(PGPSignature var1) throws SignatureValidationException;

    public static boolean verifyUninitializedSignature(PGPSignature signature, InputStream signedData, PGPPublicKey signingKey, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureValidator.initializeSignatureAndUpdateWithSignedData(signature, signedData, signingKey);
        return SignatureValidator.verifyInitializedSignature(signature, signingKey, policy, validationDate);
    }

    public static void initializeSignatureAndUpdateWithSignedData(PGPSignature signature, InputStream signedData, PGPPublicKey signingKey) throws SignatureValidationException {
        try {
            int read;
            signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), signingKey);
            while ((read = signedData.read()) != -1) {
                signature.update((byte)read);
            }
        }
        catch (PGPException e) {
            throw new SignatureValidationException("Cannot init signature.", e);
        }
        catch (IOException e) {
            throw new SignatureValidationException("Cannot update signature.", e);
        }
    }

    public static boolean verifyInitializedSignature(PGPSignature signature, PGPPublicKey signingKey, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(validationDate).verify(signature);
        try {
            if (!signature.verify()) {
                throw new SignatureValidationException("Signature is not correct.");
            }
            return true;
        }
        catch (PGPException e) {
            throw new SignatureValidationException("Could not verify signature correctness.", e);
        }
    }

    public static boolean verifySignatureOverUserId(String userId, PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date validationDate) throws SignatureValidationException {
        return SignatureValidator.verifySignatureOverUserId(userId, signature, primaryKey, primaryKey, policy, validationDate);
    }

    public static boolean verifySignatureOverUserId(String userId, PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey keyWithUserId, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureType type = SignatureType.valueOf(signature.getSignatureType());
        switch (type) {
            case GENERIC_CERTIFICATION: 
            case NO_CERTIFICATION: 
            case CASUAL_CERTIFICATION: 
            case POSITIVE_CERTIFICATION: {
                return SignatureValidator.verifyUserIdCertification(userId, signature, signingKey, keyWithUserId, policy, validationDate);
            }
            case CERTIFICATION_REVOCATION: {
                return SignatureValidator.verifyUserIdRevocation(userId, signature, signingKey, keyWithUserId, policy, validationDate);
            }
        }
        throw new SignatureValidationException("Signature is not a valid user-id certification/revocation signature: " + (Object)((Object)type));
    }

    public static boolean verifyUserIdCertification(String userId, PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date validationDate) throws SignatureValidationException {
        return SignatureValidator.verifyUserIdCertification(userId, signature, primaryKey, primaryKey, policy, validationDate);
    }

    public static boolean verifyUserIdCertification(String userId, PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey keyWithUserId, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureValidator.signatureIsCertification().verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(validationDate).verify(signature);
        SignatureValidator.correctSignatureOverUserId(userId, keyWithUserId, signingKey).verify(signature);
        return true;
    }

    public static boolean verifyUserIdRevocation(String userId, PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date validationDate) throws SignatureValidationException {
        return SignatureValidator.verifyUserIdRevocation(userId, signature, primaryKey, primaryKey, policy, validationDate);
    }

    public static boolean verifyUserIdRevocation(String userId, PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey keyWithUserId, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureValidator.signatureIsOfType(SignatureType.CERTIFICATION_REVOCATION).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(validationDate).verify(signature);
        SignatureValidator.correctSignatureOverUserId(userId, keyWithUserId, signingKey).verify(signature);
        return true;
    }

    public static boolean verifyUserAttributesCertification(PGPUserAttributeSubpacketVector userAttributes, PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date validationDate) throws SignatureValidationException {
        return SignatureValidator.verifyUserAttributesCertification(userAttributes, signature, primaryKey, primaryKey, policy, validationDate);
    }

    public static boolean verifyUserAttributesCertification(PGPUserAttributeSubpacketVector userAttributes, PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey keyWithUserAttributes, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureValidator.signatureIsCertification().verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(validationDate).verify(signature);
        SignatureValidator.correctSignatureOverUserAttributes(userAttributes, keyWithUserAttributes, signingKey).verify(signature);
        return true;
    }

    public static boolean verifyUserAttributesRevocation(PGPUserAttributeSubpacketVector userAttributes, PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date validationDate) throws SignatureValidationException {
        return SignatureValidator.verifyUserAttributesRevocation(userAttributes, signature, primaryKey, primaryKey, policy, validationDate);
    }

    public static boolean verifyUserAttributesRevocation(PGPUserAttributeSubpacketVector userAttributes, PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey keyWithUserAttributes, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureValidator.signatureIsOfType(SignatureType.CERTIFICATION_REVOCATION).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(validationDate).verify(signature);
        SignatureValidator.correctSignatureOverUserAttributes(userAttributes, keyWithUserAttributes, signingKey).verify(signature);
        return true;
    }

    public static boolean verifySubkeyBindingSignature(PGPSignature signature, PGPPublicKey primaryKey, PGPPublicKey subkey, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureValidator.signatureIsOfType(SignatureType.SUBKEY_BINDING).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(validationDate).verify(signature);
        SignatureValidator.hasValidPrimaryKeyBindingSignatureIfRequired(primaryKey, subkey, policy, validationDate).verify(signature);
        SignatureValidator.correctSubkeyBindingSignature(primaryKey, subkey).verify(signature);
        return true;
    }

    public static boolean verifySubkeyBindingRevocation(PGPSignature signature, PGPPublicKey primaryKey, PGPPublicKey subkey, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureValidator.signatureIsOfType(SignatureType.SUBKEY_REVOCATION).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(validationDate).verify(signature);
        SignatureValidator.correctSignatureOverKey(primaryKey, subkey).verify(signature);
        return true;
    }

    public static boolean verifyDirectKeySignature(PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date validationDate) throws SignatureValidationException {
        return SignatureValidator.verifyDirectKeySignature(signature, primaryKey, primaryKey, policy, validationDate);
    }

    public static boolean verifyDirectKeySignature(PGPSignature signature, PGPPublicKey signingKey, PGPPublicKey signedKey, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureValidator.signatureIsOfType(SignatureType.DIRECT_KEY).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(validationDate).verify(signature);
        SignatureValidator.correctSignatureOverKey(signingKey, signedKey).verify(signature);
        return true;
    }

    public static boolean verifyKeyRevocationSignature(PGPSignature signature, PGPPublicKey primaryKey, Policy policy, Date validationDate) throws SignatureValidationException {
        SignatureValidator.signatureIsOfType(SignatureType.KEY_REVOCATION).verify(signature);
        SignatureValidator.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
        SignatureValidator.signatureIsEffective(validationDate).verify(signature);
        SignatureValidator.correctSignatureOverKey(primaryKey, primaryKey).verify(signature);
        return true;
    }

    private static SignatureValidator hasValidPrimaryKeyBindingSignatureIfRequired(final PGPPublicKey primaryKey, final PGPPublicKey subkey, final Policy policy, final Date validationDate) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                if (!PublicKeyAlgorithm.fromId(signature.getKeyAlgorithm()).isSigningCapable()) {
                    return;
                }
                try {
                    PGPSignatureList embeddedSignatures = SignatureSubpacketsUtil.getEmbeddedSignature(signature);
                    boolean hasValidPrimaryKeyBinding = false;
                    ConcurrentHashMap<PGPSignature, Exception> rejectedEmbeddedSigs = new ConcurrentHashMap<PGPSignature, Exception>();
                    for (PGPSignature embedded : embeddedSignatures) {
                        if (SignatureType.valueOf(embedded.getSignatureType()) != SignatureType.PRIMARYKEY_BINDING) continue;
                        try {
                            1.signatureStructureIsAcceptable(subkey, policy).verify(embedded);
                            1.signatureIsEffective(validationDate).verify(embedded);
                            1.correctPrimaryKeyBindingSignature(primaryKey, subkey).verify(embedded);
                            hasValidPrimaryKeyBinding = true;
                            break;
                        }
                        catch (SignatureValidationException e) {
                            rejectedEmbeddedSigs.put(embedded, e);
                        }
                    }
                    if (!hasValidPrimaryKeyBinding) {
                        throw new SignatureValidationException("Missing primary key binding signature on signing capable subkey " + Long.toHexString(subkey.getKeyID()), rejectedEmbeddedSigs);
                    }
                }
                catch (PGPException e) {
                    throw new SignatureValidationException("Cannot process list of embedded signatures.", e);
                }
            }
        };
    }

    public static SignatureValidator signatureStructureIsAcceptable(final PGPPublicKey signingKey, final Policy policy) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                2.signatureIsNotMalformed(signingKey).verify(signature);
                2.signatureDoesNotHaveCriticalUnknownNotations(policy.getNotationRegistry()).verify(signature);
                2.signatureDoesNotHaveCriticalUnknownSubpackets().verify(signature);
                SignatureValidator.signatureUsesAcceptableHashAlgorithm(policy).verify(signature);
            }
        };
    }

    private static SignatureValidator signatureUsesAcceptableHashAlgorithm(final Policy policy) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                HashAlgorithm hashAlgorithm = HashAlgorithm.fromId(signature.getHashAlgorithm());
                Policy.HashAlgorithmPolicy hashAlgorithmPolicy = SignatureValidator.getHashAlgorithmPolicyForSignature(signature, policy);
                if (!hashAlgorithmPolicy.isAcceptable(signature.getHashAlgorithm())) {
                    throw new SignatureValidationException("Signature uses unacceptable hash algorithm " + (Object)((Object)hashAlgorithm));
                }
            }
        };
    }

    private static Policy.HashAlgorithmPolicy getHashAlgorithmPolicyForSignature(PGPSignature signature, Policy policy) {
        Policy.HashAlgorithmPolicy hashAlgorithmPolicy = null;
        SignatureType type = SignatureType.valueOf(signature.getSignatureType());
        hashAlgorithmPolicy = type == SignatureType.CERTIFICATION_REVOCATION || type == SignatureType.KEY_REVOCATION || type == SignatureType.SUBKEY_REVOCATION ? policy.getRevocationSignatureHashAlgorithmPolicy() : policy.getSignatureHashAlgorithmPolicy();
        return hashAlgorithmPolicy;
    }

    public static SignatureValidator signatureDoesNotHaveCriticalUnknownNotations(final NotationRegistry registry) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                List<NotationData> hashedNotations = SignatureSubpacketsUtil.getHashedNotationData(signature);
                for (NotationData notation : hashedNotations) {
                    if (!notation.isCritical() || registry.isKnownNotation(notation.getNotationName())) continue;
                    throw new SignatureValidationException("Signature contains unknown critical notation '" + notation.getNotationName() + "' in its hashed area.");
                }
            }
        };
    }

    public static SignatureValidator signatureDoesNotHaveCriticalUnknownSubpackets() {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                PGPSignatureSubpacketVector hashedSubpackets = signature.getHashedSubPackets();
                for (int criticalTag : hashedSubpackets.getCriticalTags()) {
                    try {
                        SignatureSubpacket.fromCode(criticalTag);
                    }
                    catch (IllegalArgumentException e) {
                        throw new SignatureValidationException("Signature contains unknown critical subpacket of type " + Long.toHexString(criticalTag));
                    }
                }
            }
        };
    }

    public static SignatureValidator signatureIsEffective(final Date validationDate) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                6.signatureIsAlreadyEffective(validationDate).verify(signature);
                6.signatureIsNotYetExpired(validationDate).verify(signature);
            }
        };
    }

    public static SignatureValidator signatureIsAlreadyEffective(final Date validationDate) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                Date signatureCreationTime = SignatureSubpacketsUtil.getSignatureCreationTime(signature).getTime();
                if (SignatureUtils.isHardRevocation(signature)) {
                    return;
                }
                if (signatureCreationTime.after(validationDate)) {
                    throw new SignatureValidationException("Signature was created at " + signatureCreationTime + " and is therefore not yet valid at " + validationDate);
                }
            }
        };
    }

    public static SignatureValidator signatureIsNotYetExpired(final Date validationDate) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                if (SignatureUtils.isHardRevocation(signature)) {
                    return;
                }
                Date signatureExpirationTime = SignatureSubpacketsUtil.getSignatureExpirationTimeAsDate(signature);
                if (signatureExpirationTime != null && signatureExpirationTime.before(validationDate)) {
                    throw new SignatureValidationException("Signature is already expired (expiration: " + signatureExpirationTime + ", validation: " + validationDate + ")");
                }
            }
        };
    }

    public static SignatureValidator signatureIsNotMalformed(final PGPPublicKey creator) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                9.signatureHasHashedCreationTime().verify(signature);
                9.signatureDoesNotPredateSigningKey(creator).verify(signature);
                9.signatureDoesNotPredateSigningKeyBindingDate(creator).verify(signature);
            }
        };
    }

    public static SignatureValidator signatureHasHashedCreationTime() {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                SignatureCreationTime creationTime = SignatureSubpacketsUtil.getSignatureCreationTime(signature);
                if (creationTime == null) {
                    throw new SignatureValidationException("Malformed signature. Signature has no signature creation time subpacket in its hashed area.");
                }
            }
        };
    }

    public static SignatureValidator signatureDoesNotPredateSigningKey(final PGPPublicKey key) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                Date signatureCreationTime;
                Date keyCreationTime = key.getCreationTime();
                if (keyCreationTime.after(signatureCreationTime = signature.getCreationTime())) {
                    throw new SignatureValidationException("Signature predates its signing key (key creation: " + keyCreationTime + ", signature creation: " + signatureCreationTime + ")");
                }
            }
        };
    }

    public static SignatureValidator signatureDoesNotPredateSigningKeyBindingDate(final PGPPublicKey signingKey) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                if (signingKey.isMasterKey()) {
                    return;
                }
                boolean predatesBindingSig = true;
                Iterator bindingSignatures = signingKey.getSignaturesOfType(SignatureType.SUBKEY_BINDING.getCode());
                if (!bindingSignatures.hasNext()) {
                    throw new SignatureValidationException("Signing subkey does not have a subkey binding signature.");
                }
                while (bindingSignatures.hasNext()) {
                    PGPSignature bindingSig = (PGPSignature)bindingSignatures.next();
                    if (bindingSig.getCreationTime().after(signature.getCreationTime())) continue;
                    predatesBindingSig = false;
                }
                if (predatesBindingSig) {
                    throw new SignatureValidationException("Signature was created before the signing key was bound to the key ring.");
                }
            }
        };
    }

    public static SignatureValidator correctSubkeyBindingSignature(final PGPPublicKey primaryKey, final PGPPublicKey subkey) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                if (primaryKey.getKeyID() == subkey.getKeyID()) {
                    throw new SignatureValidationException("Primary key cannot be its own subkey.");
                }
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), primaryKey);
                    boolean valid = signature.verifyCertification(primaryKey, subkey);
                    if (!valid) {
                        throw new SignatureValidationException("Signature is not correct.");
                    }
                }
                catch (PGPException e) {
                    throw new SignatureValidationException("Cannot verify subkey binding signature correctness", e);
                }
            }
        };
    }

    public static SignatureValidator correctPrimaryKeyBindingSignature(final PGPPublicKey primaryKey, final PGPPublicKey subkey) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), subkey);
                    boolean valid = signature.verifyCertification(primaryKey, subkey);
                    if (!valid) {
                        throw new SignatureValidationException("Primary Key Binding Signature is not correct.");
                    }
                }
                catch (PGPException e) {
                    throw new SignatureValidationException("Cannot verify primary key binding signature correctness", e);
                }
            }
        };
    }

    public static SignatureValidator correctSignatureOverKey(final PGPPublicKey signer, final PGPPublicKey signee) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), signer);
                    boolean valid = false;
                    valid = signer.getKeyID() != signee.getKeyID() ? signature.verifyCertification(signer, signee) : signature.verifyCertification(signee);
                    if (!valid) {
                        throw new SignatureValidationException("Signature is not correct.");
                    }
                }
                catch (PGPException e) {
                    throw new SignatureValidationException("Cannot verify direct-key signature correctness", e);
                }
            }
        };
    }

    public static SignatureValidator signatureIsCertification() {
        return SignatureValidator.signatureIsOfType(SignatureType.POSITIVE_CERTIFICATION, SignatureType.CASUAL_CERTIFICATION, SignatureType.GENERIC_CERTIFICATION, SignatureType.NO_CERTIFICATION);
    }

    public static SignatureValidator signatureIsOfType(final SignatureType ... signatureTypes) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                SignatureType type = SignatureType.valueOf(signature.getSignatureType());
                boolean valid = false;
                for (SignatureType allowed : signatureTypes) {
                    if (type != allowed) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    throw new SignatureValidationException("Signature is of type " + (Object)((Object)type) + " while only " + Arrays.toString((Object[])signatureTypes) + " are allowed here.");
                }
            }
        };
    }

    public static SignatureValidator correctSignatureOverUserId(final String userId, final PGPPublicKey certifiedKey, final PGPPublicKey certifyingKey) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), certifyingKey);
                    boolean valid = signature.verifyCertification(userId, certifiedKey);
                    if (!valid) {
                        throw new SignatureValidationException("Signature over user-id '" + userId + "' is not correct.");
                    }
                }
                catch (PGPException e) {
                    throw new SignatureValidationException("Cannot verify signature over user-id '" + userId + "'.", e);
                }
            }
        };
    }

    public static SignatureValidator correctSignatureOverUserAttributes(final PGPUserAttributeSubpacketVector userAttributes, final PGPPublicKey certifiedKey, final PGPPublicKey certifyingKey) {
        return new SignatureValidator(){

            @Override
            public void verify(PGPSignature signature) throws SignatureValidationException {
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), certifyingKey);
                    boolean valid = signature.verifyCertification(userAttributes, certifiedKey);
                    if (!valid) {
                        throw new SignatureValidationException("Signature over user-attribute vector is not correct.");
                    }
                }
                catch (PGPException e) {
                    throw new SignatureValidationException("Cannot verify signature over user-attribute vector.", e);
                }
            }
        };
    }
}

