/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless;

import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.decryption_verification.DecryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionBuilder;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditor;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.parsing.KeyRingReader;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.cleartext_signatures.VerifyCleartextSignatures;
import org.pgpainless.signature.cleartext_signatures.VerifyCleartextSignaturesImpl;

public class PGPainless {
    public static KeyRingBuilder generateKeyRing() {
        return new KeyRingBuilder();
    }

    public static KeyRingReader readKeyRing() {
        return new KeyRingReader();
    }

    @Deprecated
    public static EncryptionBuilder createEncryptor() {
        return PGPainless.encryptAndOrSign();
    }

    public static EncryptionBuilder encryptAndOrSign() {
        return new EncryptionBuilder();
    }

    public static EncryptionBuilder encryptAndOrSign(EncryptionPurpose purpose) {
        return new EncryptionBuilder(purpose);
    }

    @Deprecated
    public static DecryptionBuilder createDecryptor() {
        return PGPainless.decryptAndOrVerify();
    }

    public static DecryptionBuilder decryptAndOrVerify() {
        return new DecryptionBuilder();
    }

    public static VerifyCleartextSignatures verifyCleartextSignedMessage() {
        return new VerifyCleartextSignaturesImpl();
    }

    public static SecretKeyRingEditorInterface modifyKeyRing(PGPSecretKeyRing secretKeys) {
        return new SecretKeyRingEditor(secretKeys);
    }

    public static KeyRingInfo inspectKeyRing(PGPKeyRing keyRing) {
        return new KeyRingInfo(keyRing);
    }

    public static Policy getPolicy() {
        return Policy.getInstance();
    }
}

