/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import javax.annotation.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.SigningOptions;

public final class ProducerOptions {
    private final EncryptionOptions encryptionOptions;
    private final SigningOptions signingOptions;
    private CompressionAlgorithm compressionAlgorithmOverride = PGPainless.getPolicy().getCompressionAlgorithmPolicy().defaultCompressionAlgorithm();
    private boolean asciiArmor = true;

    private ProducerOptions(EncryptionOptions encryptionOptions, SigningOptions signingOptions) {
        this.encryptionOptions = encryptionOptions;
        this.signingOptions = signingOptions;
    }

    public static ProducerOptions signAndEncrypt(EncryptionOptions encryptionOptions, SigningOptions signingOptions) {
        ProducerOptions.throwIfNull(encryptionOptions);
        ProducerOptions.throwIfNull(signingOptions);
        return new ProducerOptions(encryptionOptions, signingOptions);
    }

    public static ProducerOptions sign(SigningOptions signingOptions) {
        ProducerOptions.throwIfNull(signingOptions);
        return new ProducerOptions(null, signingOptions);
    }

    public static ProducerOptions encrypt(EncryptionOptions encryptionOptions) {
        ProducerOptions.throwIfNull(encryptionOptions);
        return new ProducerOptions(encryptionOptions, null);
    }

    public static ProducerOptions noEncryptionNoSigning() {
        return new ProducerOptions(null, null);
    }

    private static void throwIfNull(EncryptionOptions encryptionOptions) {
        if (encryptionOptions == null) {
            throw new NullPointerException("EncryptionOptions cannot be null.");
        }
    }

    private static void throwIfNull(SigningOptions signingOptions) {
        if (signingOptions == null) {
            throw new NullPointerException("SigningOptions cannot be null.");
        }
    }

    public ProducerOptions overrideCompressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
        if (compressionAlgorithm == null) {
            throw new NullPointerException("Compression algorithm cannot be null.");
        }
        this.compressionAlgorithmOverride = compressionAlgorithm;
        return this;
    }

    public ProducerOptions setAsciiArmor(boolean asciiArmor) {
        this.asciiArmor = asciiArmor;
        return this;
    }

    public boolean isAsciiArmor() {
        return this.asciiArmor;
    }

    public CompressionAlgorithm getCompressionAlgorithmOverride() {
        return this.compressionAlgorithmOverride;
    }

    @Nullable
    public EncryptionOptions getEncryptionOptions() {
        return this.encryptionOptions;
    }

    @Nullable
    public SigningOptions getSigningOptions() {
        return this.signingOptions;
    }
}

